#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class CredentialsBodyOneOf2(APIObject):
    """
    Attributes
    ----------
    credential_type:str
         Credentials type.. defaults to "s3", must be one of ["s3", ]
    name:str
         Credentials name.
    aws_access_key_id:str [optional]
         AWS access key ID.. 
    aws_secret_access_key:str [optional]
         AWS secret access key.. 
    aws_session_token:str [optional]
         AWS session token.. 
    description:str [optional]
         Credentials description.. 
    """
    _converter = t.Dict(
        {
            t.Key("credential_type"):  t.String(),
            t.Key("name"):  t.String(),
            t.Key("aws_access_key_id", optional=True):  t.String(),
            t.Key("aws_secret_access_key", optional=True):  t.String(),
            t.Key("aws_session_token", optional=True):  t.String(),
            t.Key("description", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        credential_type,
        name,
        aws_access_key_id=None,
        aws_secret_access_key=None,
        aws_session_token=None,
        description=None,
    ):
        self.credential_type = credential_type
        self.name = name
        self.aws_access_key_id = aws_access_key_id
        self.aws_secret_access_key = aws_secret_access_key
        self.aws_session_token = aws_session_token
        self.description = description

    def __repr__(self):
        return (
            "CredentialsBodyOneOf2("
            "credential_type={0.credential_type}, "
            "name={0.name}, "
            "aws_access_key_id={0.aws_access_key_id}, "
            "aws_secret_access_key={0.aws_secret_access_key}, "
            "aws_session_token={0.aws_session_token}, "
            "description={0.description}, "
        ).format(self)
