#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.gcp_key import GCPKey

class CredentialsBodyOneOf3(APIObject):
    """
    Attributes
    ----------
    credential_type:str
         Credentials type.. defaults to "gcp", must be one of ["gcp", ]
    gcp_key:GCPKey
        
    name:str
         Credentials name.
    description:str [optional]
         Credentials description.. 
    """
    _converter = t.Dict(
        {
            t.Key("credential_type"):  t.String(),
            t.Key("gcp_key"):  t.Any(),
            t.Key("name"):  t.String(),
            t.Key("description", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        credential_type,
        gcp_key,
        name,
        description=None,
    ):
        self.credential_type = credential_type
        self.gcp_key = gcp_key
        self.name = name
        self.description = description

    def __repr__(self):
        return (
            "CredentialsBodyOneOf3("
            "credential_type={0.credential_type}, "
            "gcp_key={0.gcp_key}, "
            "name={0.name}, "
            "description={0.description}, "
        ).format(self)
