#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class CredentialsBodyOneOf4(APIObject):
    """
    Attributes
    ----------
    azure_connection_string:str
         Azure connection string.
    credential_type:str
         Credentials type.. defaults to "azure", must be one of ["azure", ]
    name:str
         Credentials name.
    description:str [optional]
         Credentials description.. 
    """
    _converter = t.Dict(
        {
            t.Key("azure_connection_string"):  t.String(),
            t.Key("credential_type"):  t.String(),
            t.Key("name"):  t.String(),
            t.Key("description", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        azure_connection_string,
        credential_type,
        name,
        description=None,
    ):
        self.azure_connection_string = azure_connection_string
        self.credential_type = credential_type
        self.name = name
        self.description = description

    def __repr__(self):
        return (
            "CredentialsBodyOneOf4("
            "azure_connection_string={0.azure_connection_string}, "
            "credential_type={0.credential_type}, "
            "name={0.name}, "
            "description={0.description}, "
        ).format(self)
