#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class CredentialsBodyOneOf5(APIObject):
    """
    Attributes
    ----------
    credential_type:str
         Credentials type.. defaults to "snowflake_oauth_user_account", must be one of ["snowflake_oauth_user_account", ]
    name:str
         Credentials name.
    client_id:str [optional]
         Snowflake OAUTH client ID.. 
    client_secret:str [optional]
         Snowflake OAUTH client secret.. 
    description:str [optional]
         Credentials description.. 
    snowflake_account_name:str [optional]
         Snowflake account name.. 
    """
    _converter = t.Dict(
        {
            t.Key("credential_type"):  t.String(),
            t.Key("name"):  t.String(),
            t.Key("client_id", optional=True):  t.String(),
            t.Key("client_secret", optional=True):  t.String(),
            t.Key("description", optional=True):  t.String(),
            t.Key("snowflake_account_name", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        credential_type,
        name,
        client_id=None,
        client_secret=None,
        description=None,
        snowflake_account_name=None,
    ):
        self.credential_type = credential_type
        self.name = name
        self.client_id = client_id
        self.client_secret = client_secret
        self.description = description
        self.snowflake_account_name = snowflake_account_name

    def __repr__(self):
        return (
            "CredentialsBodyOneOf5("
            "credential_type={0.credential_type}, "
            "name={0.name}, "
            "client_id={0.client_id}, "
            "client_secret={0.client_secret}, "
            "description={0.description}, "
            "snowflake_account_name={0.snowflake_account_name}, "
        ).format(self)
