#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class CredentialsCatalogDataSourcePayload(APIObject):
    """
    Attributes
    ----------
    credential_id:str
         Id of the stored credentials
    datasource_id:str
         Id of the Catalog object
    type_id:str
         Id of the target, currently only `catalog`. defaults to "catalog", must be one of ["catalog", ]
    """
    _converter = t.Dict(
        {
            t.Key("credential_id"):  t.String(),
            t.Key("datasource_id"):  t.String(),
            t.Key("type_id"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        credential_id,
        datasource_id,
        type_id,
    ):
        self.credential_id = credential_id
        self.datasource_id = datasource_id
        self.type_id = type_id

    def __repr__(self):
        return (
            "CredentialsCatalogDataSourcePayload("
            "credential_id={0.credential_id}, "
            "datasource_id={0.datasource_id}, "
            "type_id={0.type_id}, "
        ).format(self)
