#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.gcp_key import GCPKey

class CredentialsUpdate(APIObject):
    """
    Attributes
    ----------
    aws_access_key_id:str [optional]
         AWS access key ID (applicable for credentialType `s3` only).. 
    aws_secret_access_key:str [optional]
         The AWS secret access key (applicable for credentialType `s3` only).. 
    aws_session_token:str [optional]
         The AWS session token (applicable for credentialType `s3` only).. 
    azure_connection_string:str [optional]
         Azure connection string (applicable for credentialType `azure` only).. 
    client_id:str [optional]
         Snowflake OAUTH client ID (applicable for credentialType `snowflake_oauth_user_account` only).. 
    client_secret:str [optional]
         Snowflake OAUTH client secret (applicable for credentialType `snowflake_oauth_user_account` only).. 
    description:str [optional]
         Description of credentials. If omitted, and name is not omitted, clears any previous description for that name.. 
    gcp_key:GCPKey [optional]
         
    name:str [optional]
         Name of credentials.. 
    password:str [optional]
         Password to update for this set of credentials (applicable for credentialType `basic` only).. 
    refresh_token:str [optional]
         OAUTH refresh token (applicable for credentialType `oauth` only).. 
    snowflake_account_name:str [optional]
         Snowflake account name (applicable for `snowflake_oauth_user_account` only).. 
    token:str [optional]
         OAUTH token (applicable for credentialType `oauth` only).. 
    user:str [optional]
         Username to update for this set of credentials (applicable for credentialType `basic` only).. 
    """
    _converter = t.Dict(
        {
            t.Key("aws_access_key_id", optional=True):  t.String(),
            t.Key("aws_secret_access_key", optional=True):  t.String(),
            t.Key("aws_session_token", optional=True):  t.String(),
            t.Key("azure_connection_string", optional=True):  t.String(),
            t.Key("client_id", optional=True):  t.String(),
            t.Key("client_secret", optional=True):  t.String(),
            t.Key("description", optional=True):  t.String(),
            t.Key("gcp_key", optional=True):  t.Any(),
            t.Key("name", optional=True):  t.String(),
            t.Key("password", optional=True):  t.String(),
            t.Key("refresh_token", optional=True):  t.String(),
            t.Key("snowflake_account_name", optional=True):  t.String(),
            t.Key("token", optional=True):  t.String(),
            t.Key("user", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        aws_access_key_id=None,
        aws_secret_access_key=None,
        aws_session_token=None,
        azure_connection_string=None,
        client_id=None,
        client_secret=None,
        description=None,
        gcp_key=None,
        name=None,
        password=None,
        refresh_token=None,
        snowflake_account_name=None,
        token=None,
        user=None,
    ):
        self.aws_access_key_id = aws_access_key_id
        self.aws_secret_access_key = aws_secret_access_key
        self.aws_session_token = aws_session_token
        self.azure_connection_string = azure_connection_string
        self.client_id = client_id
        self.client_secret = client_secret
        self.description = description
        self.gcp_key = gcp_key
        self.name = name
        self.password = password
        self.refresh_token = refresh_token
        self.snowflake_account_name = snowflake_account_name
        self.token = token
        self.user = user

    def __repr__(self):
        return (
            "CredentialsUpdate("
            "aws_access_key_id={0.aws_access_key_id}, "
            "aws_secret_access_key={0.aws_secret_access_key}, "
            "aws_session_token={0.aws_session_token}, "
            "azure_connection_string={0.azure_connection_string}, "
            "client_id={0.client_id}, "
            "client_secret={0.client_secret}, "
            "description={0.description}, "
            "gcp_key={0.gcp_key}, "
            "name={0.name}, "
            "password={0.password}, "
            "refresh_token={0.refresh_token}, "
            "snowflake_account_name={0.snowflake_account_name}, "
            "token={0.token}, "
            "user={0.user}, "
        ).format(self)
