#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.per_class_accuracy import PerClassAccuracy

class CrossClassAccuracy(APIObject):
    """
    Attributes
    ----------
    feature:str
         The name of the categorical feature.
    model_id:str
         ID of the model for the cross-class accuracy scores.
    per_class_accuracy_scores:[PerClassAccuracy]
         An array of metric scores for each class of the feature.
    prediction_threshold:float
         Value of the prediction threshold for the model.
    """
    _converter = t.Dict(
        {
            t.Key("feature"):  t.String(),
            t.Key("model_id"):  t.String(),
            t.Key("per_class_accuracy_scores"):  t.List(t.Dict().allow_extra("*")),
            t.Key("prediction_threshold"):  t.Float(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        feature,
        model_id,
        per_class_accuracy_scores,
        prediction_threshold,
    ):
        self.feature = feature
        self.model_id = model_id
        self.per_class_accuracy_scores = per_class_accuracy_scores
        self.prediction_threshold = prediction_threshold

    def __repr__(self):
        return (
            "CrossClassAccuracy("
            "feature={0.feature}, "
            "model_id={0.model_id}, "
            "per_class_accuracy_scores={0.per_class_accuracy_scores}, "
            "prediction_threshold={0.prediction_threshold}, "
        ).format(self)
