#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class CrossSeriesGroupByColumnValidatePayload(APIObject):
    """
    Attributes
    ----------
    datetime_partition_column:str
         The name of the column that will be used as the datetime partitioning column.
    multiseries_id_column:str
         The name of the column that wil be used as the multiseries ID column for this project.
    cross_series_group_by_columns:[str] [optional]
         If specified, these columns will be validated for usage as the group-by column for creating cross-series features. If not present, then all columns from the dataset will be validated and only the eligible ones returned. To be valid, a column should be categorical or numerical (but not float), not be the series ID or equivalent to the series ID, not split any series, and not consist of only one value.. 
    user_defined_segment_id_column:str [optional]
         The name of the column that wil be used as the user defined segment ID column for this project.. 
    """
    _converter = t.Dict(
        {
            t.Key("datetime_partition_column"):  t.String(),
            t.Key("multiseries_id_column"):  t.String(),
            t.Key("cross_series_group_by_columns", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("user_defined_segment_id_column", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        datetime_partition_column,
        multiseries_id_column,
        cross_series_group_by_columns=None,
        user_defined_segment_id_column=None,
    ):
        self.datetime_partition_column = datetime_partition_column
        self.multiseries_id_column = multiseries_id_column
        self.cross_series_group_by_columns = cross_series_group_by_columns
        self.user_defined_segment_id_column = user_defined_segment_id_column

    def __repr__(self):
        return (
            "CrossSeriesGroupByColumnValidatePayload("
            "datetime_partition_column={0.datetime_partition_column}, "
            "multiseries_id_column={0.multiseries_id_column}, "
            "cross_series_group_by_columns={0.cross_series_group_by_columns}, "
            "user_defined_segment_id_column={0.user_defined_segment_id_column}, "
        ).format(self)
