#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class CustomModelCreate(APIObject):
    """
    Attributes
    ----------
    custom_model_type:str
         The type of custom model.
    name:str
         The user-friendly name for the model.
    calibrate_predictions:bool [optional]
         Whether model predictions should be calibrated by DataRobot.Only applies to anomaly detection training tasks; we recommend this if you have not already included calibration in your model code.Calibration improves the probability estimates of a model, and modifies the predictions of non-probabilistic models to be interpretable as probabilities. This will facilitate comparison to DataRobot models, and give access to ROC curve insights on external data..  if omitted the server will use the default value of True
    class_labels:[str] [optional]
         The class labels for multiclass classification. Required for multiclass inference models. If using one of the [DataRobot] base environments and your model produces an ndarray of unlabeled class probabilities, the order of the labels should match the order of the predicted output. 
    description:str [optional]
         The user-friendly description of the model.. 
    desired_memory:int, none_type [optional]
         The amount of memory that is expected to be allocated by the custom model.. 
    language:str [optional]
         Programming language name in which model is written.. 
    maximum_memory:int, none_type [optional]
         The maximum memory that might be allocated by the custom-model. If exceeded, the custom-model will be killed. 
    negative_class_label:str, none_type [optional]
         The negative class label for custom models that support binary classification. If specified, `positiveClassLabel` must also be specified. Default value is \"0\".. 
    network_egress_policy:str, none_type [optional]
         Network egress policy.. 
    positive_class_label:str, none_type [optional]
         The positive class label for custom models that support binary classification. If specified, `negativeClassLabel` must also be specified. Default value is \"1\".. 
    prediction_threshold:float [optional]
         The prediction threshold which will be used for binary classification custom model..  if omitted the server will use the default value of 0.5
    replicas:int, none_type [optional]
         A fixed number of replicas that will be set for the given custom-model.. 
    requires_ha:bool, none_type [optional]
         Require all custom model replicas to be deployed on different Kubernetes nodes for predictions fault tolerance.. 
    supports_binary_classification:bool [optional]
         Whether the model supports binary classification.. 
    supports_regression:bool [optional]
         Whether the model supports regression.. 
    target_name:str, none_type [optional]
         The name of the target for labeling predictions. Required for model type 'inference'. Specifying this value for a model type 'training' will result in an error.. 
    target_type:str [optional]
         The target type of the custom model. 
    """
    _converter = t.Dict(
        {
            t.Key("custom_model_type"):  t.String(),
            t.Key("name"):  t.String(),
            t.Key("calibrate_predictions", optional=True):  t.Bool(),
            t.Key("class_labels", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("description", optional=True):  t.String(),
            t.Key("desired_memory", optional=True):  t.Int(),
            t.Key("language", optional=True):  t.String(),
            t.Key("maximum_memory", optional=True):  t.Int(),
            t.Key("negative_class_label", optional=True):  t.String(),
            t.Key("network_egress_policy", optional=True):  t.String(),
            t.Key("positive_class_label", optional=True):  t.String(),
            t.Key("prediction_threshold", optional=True):  t.Float(),
            t.Key("replicas", optional=True):  t.Int(),
            t.Key("requires_ha", optional=True):  t.Bool(),
            t.Key("supports_binary_classification", optional=True):  t.Bool(),
            t.Key("supports_regression", optional=True):  t.Bool(),
            t.Key("target_name", optional=True):  t.String(),
            t.Key("target_type", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        custom_model_type,
        name,
        calibrate_predictions=None,
        class_labels=None,
        description=None,
        desired_memory=None,
        language=None,
        maximum_memory=None,
        negative_class_label=None,
        network_egress_policy=None,
        positive_class_label=None,
        prediction_threshold=None,
        replicas=None,
        requires_ha=None,
        supports_binary_classification=None,
        supports_regression=None,
        target_name=None,
        target_type=None,
    ):
        self.custom_model_type = custom_model_type
        self.name = name
        self.calibrate_predictions = calibrate_predictions
        self.class_labels = class_labels
        self.description = description
        self.desired_memory = desired_memory
        self.language = language
        self.maximum_memory = maximum_memory
        self.negative_class_label = negative_class_label
        self.network_egress_policy = network_egress_policy
        self.positive_class_label = positive_class_label
        self.prediction_threshold = prediction_threshold
        self.replicas = replicas
        self.requires_ha = requires_ha
        self.supports_binary_classification = supports_binary_classification
        self.supports_regression = supports_regression
        self.target_name = target_name
        self.target_type = target_type

    def __repr__(self):
        return (
            "CustomModelCreate("
            "custom_model_type={0.custom_model_type}, "
            "name={0.name}, "
            "calibrate_predictions={0.calibrate_predictions}, "
            "class_labels={0.class_labels}, "
            "description={0.description}, "
            "desired_memory={0.desired_memory}, "
            "language={0.language}, "
            "maximum_memory={0.maximum_memory}, "
            "negative_class_label={0.negative_class_label}, "
            "network_egress_policy={0.network_egress_policy}, "
            "positive_class_label={0.positive_class_label}, "
            "prediction_threshold={0.prediction_threshold}, "
            "replicas={0.replicas}, "
            "requires_ha={0.requires_ha}, "
            "supports_binary_classification={0.supports_binary_classification}, "
            "supports_regression={0.supports_regression}, "
            "target_name={0.target_name}, "
            "target_type={0.target_type}, "
        ).format(self)
