#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.custom_model_short_response import CustomModelShortResponse
from datarobot.models.full_api.generated.model.custom_model_version_short_response import CustomModelVersionShortResponse
from datarobot.models.full_api.generated.model.execution_environment_short_response import ExecutionEnvironmentShortResponse
from datarobot.models.full_api.generated.model.execution_environment_version_short_response import ExecutionEnvironmentVersionShortResponse

class CustomModelDeploymentResponse(APIObject):
    """
    Attributes
    ----------
    custom_model:CustomModelShortResponse
        
    custom_model_image_id:str
         The id of the custom model image associated with this deployment.
    custom_model_version:CustomModelVersionShortResponse
        
    deployed:str
         ISO-8601 timestamp of when deployment was created.
    deployed_by:str
         The username of the user that deployed the custom model.
    execution_environment:ExecutionEnvironmentShortResponse
        
    execution_environment_version:ExecutionEnvironmentVersionShortResponse
        
    id:str
         The ID of the deployment.
    label:str
         User-friendly name of the model deployment.
    status:str
         Deployment status.
    testing_status:str
         Latest testing status of the deployed custom model image.
    image_type:str [optional]
         The type of the image, either customModelImage if the testing attempt is using a customModelImage as its model or customModelVersion if the testing attempt is using a customModelVersion with dependency management.. 
    """
    _converter = t.Dict(
        {
            t.Key("custom_model"):  t.Any(),
            t.Key("custom_model_image_id"):  t.String(),
            t.Key("custom_model_version"):  t.Any(),
            t.Key("deployed"):  t.String(),
            t.Key("deployed_by"):  t.String(),
            t.Key("execution_environment"):  t.Any(),
            t.Key("execution_environment_version"):  t.Any(),
            t.Key("id"):  t.String(),
            t.Key("label"):  t.String(),
            t.Key("status"):  t.String(),
            t.Key("testing_status"):  t.String(),
            t.Key("image_type", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        custom_model,
        custom_model_image_id,
        custom_model_version,
        deployed,
        deployed_by,
        execution_environment,
        execution_environment_version,
        id,
        label,
        status,
        testing_status,
        image_type=None,
    ):
        self.custom_model = custom_model
        self.custom_model_image_id = custom_model_image_id
        self.custom_model_version = custom_model_version
        self.deployed = deployed
        self.deployed_by = deployed_by
        self.execution_environment = execution_environment
        self.execution_environment_version = execution_environment_version
        self.id = id
        self.label = label
        self.status = status
        self.testing_status = testing_status
        self.image_type = image_type

    def __repr__(self):
        return (
            "CustomModelDeploymentResponse("
            "custom_model={0.custom_model}, "
            "custom_model_image_id={0.custom_model_image_id}, "
            "custom_model_version={0.custom_model_version}, "
            "deployed={0.deployed}, "
            "deployed_by={0.deployed_by}, "
            "execution_environment={0.execution_environment}, "
            "execution_environment_version={0.execution_environment_version}, "
            "id={0.id}, "
            "label={0.label}, "
            "status={0.status}, "
            "testing_status={0.testing_status}, "
            "image_type={0.image_type}, "
        ).format(self)
