#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class CustomModelPerformanceCheckParameters(APIObject):
    """
    Attributes
    ----------
    max_execution_time:int [optional]
         Maximum check execution time, in seconds..  if omitted the server will use the default value of 600
    max_response_time:int [optional]
         Maximum prediction response time, in seconds..  if omitted the server will use the default value of 60
    num_parallel_users:int [optional]
         Number of parallel users making predicion requests..  if omitted the server will use the default value of 1
    """
    _converter = t.Dict(
        {
            t.Key("max_execution_time", optional=True):  t.Int(),
            t.Key("max_response_time", optional=True):  t.Int(),
            t.Key("num_parallel_users", optional=True):  t.Int(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        max_execution_time=None,
        max_response_time=None,
        num_parallel_users=None,
    ):
        self.max_execution_time = max_execution_time
        self.max_response_time = max_response_time
        self.num_parallel_users = num_parallel_users

    def __repr__(self):
        return (
            "CustomModelPerformanceCheckParameters("
            "max_execution_time={0.max_execution_time}, "
            "max_response_time={0.max_response_time}, "
            "num_parallel_users={0.num_parallel_users}, "
        ).format(self)
