#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class CustomModelPredVerificationCheckParameters(APIObject):
    """
    Attributes
    ----------
    dataset_id:str
         The ID of the dataset to use for the check.
    predictions_column:str
         The name of the column in the dataset that contains prediction results.
    comparison_precision:float [optional]
         The precision of predictions comparison..  if omitted the server will use the default value of 0.00010
    comparison_precision_type:str [optional]
         Whether predictions comparison should be done with absolute or relative precision..  if omitted the server will use the default value of "absolute"
    dataset_version_id:str [optional]
         The ID of the version of the dataset item to use as the dataset for the check. Defaults to the latest version.. 
    matching_rate:float [optional]
         Ratio of predictions required to match..  if omitted the server will use the default value of 0.95
    """
    _converter = t.Dict(
        {
            t.Key("dataset_id"):  t.String(),
            t.Key("predictions_column"):  t.String(),
            t.Key("comparison_precision", optional=True):  t.Float(),
            t.Key("comparison_precision_type", optional=True):  t.String(),
            t.Key("dataset_version_id", optional=True):  t.String(),
            t.Key("matching_rate", optional=True):  t.Float(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        dataset_id,
        predictions_column,
        comparison_precision=None,
        comparison_precision_type=None,
        dataset_version_id=None,
        matching_rate=None,
    ):
        self.dataset_id = dataset_id
        self.predictions_column = predictions_column
        self.comparison_precision = comparison_precision
        self.comparison_precision_type = comparison_precision_type
        self.dataset_version_id = dataset_version_id
        self.matching_rate = matching_rate

    def __repr__(self):
        return (
            "CustomModelPredVerificationCheckParameters("
            "dataset_id={0.dataset_id}, "
            "predictions_column={0.predictions_column}, "
            "comparison_precision={0.comparison_precision}, "
            "comparison_precision_type={0.comparison_precision_type}, "
            "dataset_version_id={0.dataset_version_id}, "
            "matching_rate={0.matching_rate}, "
        ).format(self)
