#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class CustomModelPredictionExplanations(APIObject):
    """
    Attributes
    ----------
    custom_model_id:str
         ID of the custom model.
    custom_model_version_id:str
         ID of the custom model version.
    environment_id:str [optional]
         The ID of environment to use. If not specified, the customModelVersion's dependency environment will be used.. 
    environment_version_id:str [optional]
         The ID of environment version to use. Defaults to the latest successfully built version.. 
    """
    _converter = t.Dict(
        {
            t.Key("custom_model_id"):  t.String(),
            t.Key("custom_model_version_id"):  t.String(),
            t.Key("environment_id", optional=True):  t.String(),
            t.Key("environment_version_id", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        custom_model_id,
        custom_model_version_id,
        environment_id=None,
        environment_version_id=None,
    ):
        self.custom_model_id = custom_model_id
        self.custom_model_version_id = custom_model_version_id
        self.environment_id = environment_id
        self.environment_version_id = environment_version_id

    def __repr__(self):
        return (
            "CustomModelPredictionExplanations("
            "custom_model_id={0.custom_model_id}, "
            "custom_model_version_id={0.custom_model_version_id}, "
            "environment_id={0.environment_id}, "
            "environment_version_id={0.environment_version_id}, "
        ).format(self)
