#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class CustomModelResourceLimits(APIObject):
    """
    Attributes
    ----------
    max_custom_model_testing_parallel_users:int
         The maximum number of parallel users that can be used for Custom Model Testing checks
    desired_custom_model_container_size:int, none_type [optional]
         The maximum memory that might be allocated by the custom-model. If exceeded, the custom-model will be killed. 
    max_custom_model_container_size:int, none_type [optional]
         The maximum memory that might be allocated by the custom-model. If exceeded, the custom-model will be killed. 
    max_custom_model_replicas_per_deployment:int, none_type [optional]
         A fixed number of replicas that will be set for the given custom-model.. 
    """
    _converter = t.Dict(
        {
            t.Key("max_custom_model_testing_parallel_users"):  t.Int(),
            t.Key("desired_custom_model_container_size", optional=True):  t.Int(),
            t.Key("max_custom_model_container_size", optional=True):  t.Int(),
            t.Key("max_custom_model_replicas_per_deployment", optional=True):  t.Int(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        max_custom_model_testing_parallel_users,
        desired_custom_model_container_size=None,
        max_custom_model_container_size=None,
        max_custom_model_replicas_per_deployment=None,
    ):
        self.max_custom_model_testing_parallel_users = max_custom_model_testing_parallel_users
        self.desired_custom_model_container_size = desired_custom_model_container_size
        self.max_custom_model_container_size = max_custom_model_container_size
        self.max_custom_model_replicas_per_deployment = max_custom_model_replicas_per_deployment

    def __repr__(self):
        return (
            "CustomModelResourceLimits("
            "max_custom_model_testing_parallel_users={0.max_custom_model_testing_parallel_users}, "
            "desired_custom_model_container_size={0.desired_custom_model_container_size}, "
            "max_custom_model_container_size={0.max_custom_model_container_size}, "
            "max_custom_model_replicas_per_deployment={0.max_custom_model_replicas_per_deployment}, "
        ).format(self)
