#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.custom_model_version_response import CustomModelVersionResponse

class CustomModelResponse(APIObject):
    """
    Attributes
    ----------
    created:str
         ISO-8601 timestamp of when the model was created.
    created_by:str
         The username of the custom model creator.
    deployments_count:int
         The number of models deployed.
    description:str
         The description of the model.
    id:str
         The ID of the custom model.
    language:str
         The programming language used to write the model.
    latest_version:CustomModelVersionResponse
        
    name:str
         The name of the model.
    supports_binary_classification:bool
         Whether the model supports binary classification.
    supports_regression:bool
         Whether the model supports regression.
    target_type:str
         The target type of custom model.
    updated:str
         ISO-8601 timestamp of when model was last updated.
    calibrate_predictions:bool [optional]
         Determines whether ot not predictions should be calibrated by DataRobot.Only applies to anomaly detection.. 
    class_labels:[str] [optional]
         If the model is a multiclass classifier, these are the model's class labels. 
    custom_model_type:str [optional]
         The type of custom model.. 
    desired_memory:int, none_type [optional]
         The amount of memory that is expected to be allocated by the custom model.. 
    maximum_memory:int, none_type [optional]
         The maximum memory that might be allocated by the custom-model. If exceeded, the custom-model will be killed. 
    negative_class_label:str [optional]
         If the model is a binary classifier, this is the negative class label.. 
    network_egress_policy:str, none_type [optional]
         Network egress policy.. 
    positive_class_label:str [optional]
         If the model is a binary classifier, this is the positive class label.. 
    prediction_threshold:float [optional]
         If the model is a binary classifier, this is the prediction threshold.. 
    replicas:int, none_type [optional]
         A fixed number of replicas that will be set for the given custom-model.. 
    requires_ha:bool, none_type [optional]
         Require all custom model replicas to be deployed on different Kubernetes nodes for predictions fault tolerance.. 
    supports_anomaly_detection:bool [optional]
         Whether the model supports anomaly detection.. 
    target_name:str [optional]
         The name of the target for labeling predictions.. 
    training_data_assignment_in_progress:bool [optional]
         Indicates if training data is currently being assigned to the custom model.. 
    training_data_file_name:str, none_type [optional]
         The name of the file that was used as training data if it was assigned previously.. 
    training_data_partition_column:str, none_type [optional]
         The name of the column containing the partition assignments in training data if it was assigned previously and partitioning was provided.. 
    training_dataset_id:str, none_type [optional]
         The ID of the dataset that was used as training data if it was assigned previously.. 
    training_dataset_version_id:str, none_type [optional]
         The ID of the dataset version that was used as training data if it was assigned previously.. 
    """
    _converter = t.Dict(
        {
            t.Key("created"):  t.String(),
            t.Key("created_by"):  t.String(),
            t.Key("deployments_count"):  t.Int(),
            t.Key("description"):  t.String(),
            t.Key("id"):  t.String(),
            t.Key("language"):  t.String(),
            t.Key("latest_version"):  t.Any(),
            t.Key("name"):  t.String(),
            t.Key("supports_binary_classification"):  t.Bool(),
            t.Key("supports_regression"):  t.Bool(),
            t.Key("target_type"):  t.String(),
            t.Key("updated"):  t.String(),
            t.Key("calibrate_predictions", optional=True):  t.Bool(),
            t.Key("class_labels", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("custom_model_type", optional=True):  t.String(),
            t.Key("desired_memory", optional=True):  t.Int(),
            t.Key("maximum_memory", optional=True):  t.Int(),
            t.Key("negative_class_label", optional=True):  t.String(),
            t.Key("network_egress_policy", optional=True):  t.String(),
            t.Key("positive_class_label", optional=True):  t.String(),
            t.Key("prediction_threshold", optional=True):  t.Float(),
            t.Key("replicas", optional=True):  t.Int(),
            t.Key("requires_ha", optional=True):  t.Bool(),
            t.Key("supports_anomaly_detection", optional=True):  t.Bool(),
            t.Key("target_name", optional=True):  t.String(),
            t.Key("training_data_assignment_in_progress", optional=True):  t.Bool(),
            t.Key("training_data_file_name", optional=True):  t.String(),
            t.Key("training_data_partition_column", optional=True):  t.String(),
            t.Key("training_dataset_id", optional=True):  t.String(),
            t.Key("training_dataset_version_id", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        created,
        created_by,
        deployments_count,
        description,
        id,
        language,
        latest_version,
        name,
        supports_binary_classification,
        supports_regression,
        target_type,
        updated,
        calibrate_predictions=None,
        class_labels=None,
        custom_model_type=None,
        desired_memory=None,
        maximum_memory=None,
        negative_class_label=None,
        network_egress_policy=None,
        positive_class_label=None,
        prediction_threshold=None,
        replicas=None,
        requires_ha=None,
        supports_anomaly_detection=None,
        target_name=None,
        training_data_assignment_in_progress=None,
        training_data_file_name=None,
        training_data_partition_column=None,
        training_dataset_id=None,
        training_dataset_version_id=None,
    ):
        self.created = created
        self.created_by = created_by
        self.deployments_count = deployments_count
        self.description = description
        self.id = id
        self.language = language
        self.latest_version = latest_version
        self.name = name
        self.supports_binary_classification = supports_binary_classification
        self.supports_regression = supports_regression
        self.target_type = target_type
        self.updated = updated
        self.calibrate_predictions = calibrate_predictions
        self.class_labels = class_labels
        self.custom_model_type = custom_model_type
        self.desired_memory = desired_memory
        self.maximum_memory = maximum_memory
        self.negative_class_label = negative_class_label
        self.network_egress_policy = network_egress_policy
        self.positive_class_label = positive_class_label
        self.prediction_threshold = prediction_threshold
        self.replicas = replicas
        self.requires_ha = requires_ha
        self.supports_anomaly_detection = supports_anomaly_detection
        self.target_name = target_name
        self.training_data_assignment_in_progress = training_data_assignment_in_progress
        self.training_data_file_name = training_data_file_name
        self.training_data_partition_column = training_data_partition_column
        self.training_dataset_id = training_dataset_id
        self.training_dataset_version_id = training_dataset_version_id

    def __repr__(self):
        return (
            "CustomModelResponse("
            "created={0.created}, "
            "created_by={0.created_by}, "
            "deployments_count={0.deployments_count}, "
            "description={0.description}, "
            "id={0.id}, "
            "language={0.language}, "
            "latest_version={0.latest_version}, "
            "name={0.name}, "
            "supports_binary_classification={0.supports_binary_classification}, "
            "supports_regression={0.supports_regression}, "
            "target_type={0.target_type}, "
            "updated={0.updated}, "
            "calibrate_predictions={0.calibrate_predictions}, "
            "class_labels={0.class_labels}, "
            "custom_model_type={0.custom_model_type}, "
            "desired_memory={0.desired_memory}, "
            "maximum_memory={0.maximum_memory}, "
            "negative_class_label={0.negative_class_label}, "
            "network_egress_policy={0.network_egress_policy}, "
            "positive_class_label={0.positive_class_label}, "
            "prediction_threshold={0.prediction_threshold}, "
            "replicas={0.replicas}, "
            "requires_ha={0.requires_ha}, "
            "supports_anomaly_detection={0.supports_anomaly_detection}, "
            "target_name={0.target_name}, "
            "training_data_assignment_in_progress={0.training_data_assignment_in_progress}, "
            "training_data_file_name={0.training_data_file_name}, "
            "training_data_partition_column={0.training_data_partition_column}, "
            "training_dataset_id={0.training_dataset_id}, "
            "training_dataset_version_id={0.training_dataset_version_id}, "
        ).format(self)
