#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class CustomModelStabilityCheckParameters(APIObject):
    """
    Attributes
    ----------
    max_execution_time:int [optional]
         Maximum check execution time, in seconds..  if omitted the server will use the default value of 600
    max_payload_size:int [optional]
         Maximum prediction request payload size, in number of rows..  if omitted the server will use the default value of 1000
    min_payload_size:int [optional]
         Minimum prediction request payload size, in number of rows..  if omitted the server will use the default value of 10
    num_parallel_users:int [optional]
         Number of parallel users making predicion requests..  if omitted the server will use the default value of 1
    num_predictions:int [optional]
         Number of prediction requests to perform..  if omitted the server will use the default value of 1000
    passing_rate:float [optional]
         Ratio of prediction requests required to pass..  if omitted the server will use the default value of 0.95
    """
    _converter = t.Dict(
        {
            t.Key("max_execution_time", optional=True):  t.Int(),
            t.Key("max_payload_size", optional=True):  t.Int(),
            t.Key("min_payload_size", optional=True):  t.Int(),
            t.Key("num_parallel_users", optional=True):  t.Int(),
            t.Key("num_predictions", optional=True):  t.Int(),
            t.Key("passing_rate", optional=True):  t.Float(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        max_execution_time=None,
        max_payload_size=None,
        min_payload_size=None,
        num_parallel_users=None,
        num_predictions=None,
        passing_rate=None,
    ):
        self.max_execution_time = max_execution_time
        self.max_payload_size = max_payload_size
        self.min_payload_size = min_payload_size
        self.num_parallel_users = num_parallel_users
        self.num_predictions = num_predictions
        self.passing_rate = passing_rate

    def __repr__(self):
        return (
            "CustomModelStabilityCheckParameters("
            "max_execution_time={0.max_execution_time}, "
            "max_payload_size={0.max_payload_size}, "
            "min_payload_size={0.min_payload_size}, "
            "num_parallel_users={0.num_parallel_users}, "
            "num_predictions={0.num_predictions}, "
            "passing_rate={0.passing_rate}, "
        ).format(self)
