#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.custom_model_tests_config import CustomModelTestsConfig

class CustomModelTests(APIObject):
    """
    Attributes
    ----------
    custom_model_id:str
         The ID of the custom model to test.
    custom_model_version_id:str
         The ID of custom model version to use.
    configuration:CustomModelTestsConfig [optional]
         
    dataset_id:str [optional]
         The ID of the dataset to use for testing. Dataset ID is required for regular (non-unstructured) custom models.. 
    dataset_version_id:str [optional]
         The ID of the version of the dataset item to use as the testing dataset. Defaults to the latest version.. 
    desired_memory:int, none_type [optional]
         The amount of memory that is expected to be allocated by the custom model.. 
    environment_id:str [optional]
         The ID of environment to use. If not specified, the customModelVersion's dependency environment will be used.. 
    environment_version_id:str [optional]
         The ID of environment version to use. Defaults to the latest successfully built version.. 
    maximum_memory:int, none_type [optional]
         The maximum memory that might be allocated by the custom-model. If exceeded, the custom-model will be killed. 
    network_egress_policy:str, none_type [optional]
         Network egress policy.. 
    replicas:int, none_type [optional]
         A fixed number of replicas that will be set for the given custom-model.. 
    requires_ha:bool, none_type [optional]
         Require all custom model replicas to be deployed on different Kubernetes nodes for predictions fault tolerance.. 
    """
    _converter = t.Dict(
        {
            t.Key("custom_model_id"):  t.String(),
            t.Key("custom_model_version_id"):  t.String(),
            t.Key("configuration", optional=True):  t.Any(),
            t.Key("dataset_id", optional=True):  t.String(),
            t.Key("dataset_version_id", optional=True):  t.String(),
            t.Key("desired_memory", optional=True):  t.Int(),
            t.Key("environment_id", optional=True):  t.String(),
            t.Key("environment_version_id", optional=True):  t.String(),
            t.Key("maximum_memory", optional=True):  t.Int(),
            t.Key("network_egress_policy", optional=True):  t.String(),
            t.Key("replicas", optional=True):  t.Int(),
            t.Key("requires_ha", optional=True):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        custom_model_id,
        custom_model_version_id,
        configuration=None,
        dataset_id=None,
        dataset_version_id=None,
        desired_memory=None,
        environment_id=None,
        environment_version_id=None,
        maximum_memory=None,
        network_egress_policy=None,
        replicas=None,
        requires_ha=None,
    ):
        self.custom_model_id = custom_model_id
        self.custom_model_version_id = custom_model_version_id
        self.configuration = configuration
        self.dataset_id = dataset_id
        self.dataset_version_id = dataset_version_id
        self.desired_memory = desired_memory
        self.environment_id = environment_id
        self.environment_version_id = environment_version_id
        self.maximum_memory = maximum_memory
        self.network_egress_policy = network_egress_policy
        self.replicas = replicas
        self.requires_ha = requires_ha

    def __repr__(self):
        return (
            "CustomModelTests("
            "custom_model_id={0.custom_model_id}, "
            "custom_model_version_id={0.custom_model_version_id}, "
            "configuration={0.configuration}, "
            "dataset_id={0.dataset_id}, "
            "dataset_version_id={0.dataset_version_id}, "
            "desired_memory={0.desired_memory}, "
            "environment_id={0.environment_id}, "
            "environment_version_id={0.environment_version_id}, "
            "maximum_memory={0.maximum_memory}, "
            "network_egress_policy={0.network_egress_policy}, "
            "replicas={0.replicas}, "
            "requires_ha={0.requires_ha}, "
        ).format(self)
