#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class CustomModelTestsConfig(APIObject):
    """
    Attributes
    ----------
    error_check:str [optional]
         Ensures that the model can make predictions on the provided test dataset..  if omitted the server will use the default value of "fail"
    long_running_service:str [optional]
         Ensures that the custom model image can build and launch. If it cannot, the test is marked as Failed and subsequent test are aborted..  if omitted the server will use the default value of "fail"
    null_value_imputation:str [optional]
         Verifies that the model can impute null values. Required for Feature Impact..  if omitted the server will use the default value of "warn"
    side_effects:str [optional]
         Verifies that predictions made on the dataset match row-wise predictions for the same dataset. Fails if the predictions do not match..  if omitted the server will use the default value of "warn"
    """
    _converter = t.Dict(
        {
            t.Key("error_check", optional=True):  t.String(),
            t.Key("long_running_service", optional=True):  t.String(),
            t.Key("null_value_imputation", optional=True):  t.String(),
            t.Key("side_effects", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        error_check=None,
        long_running_service=None,
        null_value_imputation=None,
        side_effects=None,
    ):
        self.error_check = error_check
        self.long_running_service = long_running_service
        self.null_value_imputation = null_value_imputation
        self.side_effects = side_effects

    def __repr__(self):
        return (
            "CustomModelTestsConfig("
            "error_check={0.error_check}, "
            "long_running_service={0.long_running_service}, "
            "null_value_imputation={0.null_value_imputation}, "
            "side_effects={0.side_effects}, "
        ).format(self)
