#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.custom_model_short_response import CustomModelShortResponse
from datarobot.models.full_api.generated.model.custom_model_testing import CustomModelTesting
from datarobot.models.full_api.generated.model.custom_model_version_short_response import CustomModelVersionShortResponse
from datarobot.models.full_api.generated.model.execution_environment_short_response import ExecutionEnvironmentShortResponse
from datarobot.models.full_api.generated.model.execution_environment_version_short_response import ExecutionEnvironmentVersionShortResponse

class CustomModelTestsResponse(APIObject):
    """
    Attributes
    ----------
    completed_at:str
         ISO-8601 timestamp of when the testing attempt was completed.
    created:str
         ISO-8601 timestamp of when the testing entry was created.
    created_by:str
         The username of the user that started the custom model test.
    custom_model:CustomModelShortResponse
        
    custom_model_image_id:str, none_type
         If testing was successful, ID of the custom inference model image that can be used for a deployment, otherwise null.
    custom_model_version:CustomModelVersionShortResponse
        
    dataset_id:str
         ID of the dataset used for testing.
    dataset_version_id:str
         ID of the specific dataset version used for testing.
    execution_environment:ExecutionEnvironmentShortResponse
        
    execution_environment_version:ExecutionEnvironmentVersionShortResponse
        
    id:str
         ID of the testing history entry.
    overall_status:str
         The overall status of the testing history entry.
    testing_status:CustomModelTesting
        
    desired_memory:int, none_type [optional]
         The amount of memory that is expected to be allocated by the custom model.. 
    image_type:str [optional]
         The type of the image, either customModelImage if the testing attempt is using a customModelImage as its model or customModelVersion if the testing attempt is using a customModelVersion with dependency management.. 
    maximum_memory:int, none_type [optional]
         The maximum memory that might be allocated by the custom-model. If exceeded, the custom-model will be killed. 
    network_egress_policy:str, none_type [optional]
         Network egress policy.. 
    replicas:int, none_type [optional]
         A fixed number of replicas that will be set for the given custom-model.. 
    requires_ha:bool, none_type [optional]
         Require all custom model replicas to be deployed on different Kubernetes nodes for predictions fault tolerance.. 
    """
    _converter = t.Dict(
        {
            t.Key("completed_at"):  t.String(),
            t.Key("created"):  t.String(),
            t.Key("created_by"):  t.String(),
            t.Key("custom_model"):  t.Any(),
            t.Key("custom_model_image_id"):  t.String(),
            t.Key("custom_model_version"):  t.Any(),
            t.Key("dataset_id"):  t.String(),
            t.Key("dataset_version_id"):  t.String(),
            t.Key("execution_environment"):  t.Any(),
            t.Key("execution_environment_version"):  t.Any(),
            t.Key("id"):  t.String(),
            t.Key("overall_status"):  t.String(),
            t.Key("testing_status"):  t.Any(),
            t.Key("desired_memory", optional=True):  t.Int(),
            t.Key("image_type", optional=True):  t.String(),
            t.Key("maximum_memory", optional=True):  t.Int(),
            t.Key("network_egress_policy", optional=True):  t.String(),
            t.Key("replicas", optional=True):  t.Int(),
            t.Key("requires_ha", optional=True):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        completed_at,
        created,
        created_by,
        custom_model,
        custom_model_image_id,
        custom_model_version,
        dataset_id,
        dataset_version_id,
        execution_environment,
        execution_environment_version,
        id,
        overall_status,
        testing_status,
        desired_memory=None,
        image_type=None,
        maximum_memory=None,
        network_egress_policy=None,
        replicas=None,
        requires_ha=None,
    ):
        self.completed_at = completed_at
        self.created = created
        self.created_by = created_by
        self.custom_model = custom_model
        self.custom_model_image_id = custom_model_image_id
        self.custom_model_version = custom_model_version
        self.dataset_id = dataset_id
        self.dataset_version_id = dataset_version_id
        self.execution_environment = execution_environment
        self.execution_environment_version = execution_environment_version
        self.id = id
        self.overall_status = overall_status
        self.testing_status = testing_status
        self.desired_memory = desired_memory
        self.image_type = image_type
        self.maximum_memory = maximum_memory
        self.network_egress_policy = network_egress_policy
        self.replicas = replicas
        self.requires_ha = requires_ha

    def __repr__(self):
        return (
            "CustomModelTestsResponse("
            "completed_at={0.completed_at}, "
            "created={0.created}, "
            "created_by={0.created_by}, "
            "custom_model={0.custom_model}, "
            "custom_model_image_id={0.custom_model_image_id}, "
            "custom_model_version={0.custom_model_version}, "
            "dataset_id={0.dataset_id}, "
            "dataset_version_id={0.dataset_version_id}, "
            "execution_environment={0.execution_environment}, "
            "execution_environment_version={0.execution_environment_version}, "
            "id={0.id}, "
            "overall_status={0.overall_status}, "
            "testing_status={0.testing_status}, "
            "desired_memory={0.desired_memory}, "
            "image_type={0.image_type}, "
            "maximum_memory={0.maximum_memory}, "
            "network_egress_policy={0.network_egress_policy}, "
            "replicas={0.replicas}, "
            "requires_ha={0.requires_ha}, "
        ).format(self)
