#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class CustomModelUpdate(APIObject):
    """
    Attributes
    ----------
    class_labels:[str] [optional]
         The class labels for multiclass classification. Required for multiclass inference models. If using one of the [DataRobot] base environments and your model produces an ndarray of unlabeled class probabilities, the order of the labels should match the order of the predicted output. 
    description:str [optional]
         The user-friendly description of the model.. 
    desired_memory:int, none_type [optional]
         The amount of memory that is expected to be allocated by the custom model.. 
    language:str [optional]
         Programming language name in which model is written.. 
    maximum_memory:int, none_type [optional]
         The maximum memory that might be allocated by the custom-model. If exceeded, the custom-model will be killed. 
    name:str [optional]
         The user-friendly name for the model.. 
    negative_class_label:str, none_type [optional]
         The negative class label for custom models that support binary classification. If specified, `positiveClassLabel` must also be specified. Default value is \"0\".. 
    network_egress_policy:str, none_type [optional]
         Network egress policy.. 
    positive_class_label:str, none_type [optional]
         The positive class label for custom models that support binary classification. If specified, `negativeClassLabel` must also be specified. Default value is \"1\".. 
    prediction_threshold:float [optional]
         The prediction threshold which will be used for binary classification custom model..  if omitted the server will use the default value of 0.5
    replicas:int, none_type [optional]
         A fixed number of replicas that will be set for the given custom-model.. 
    requires_ha:bool, none_type [optional]
         Require all custom model replicas to be deployed on different Kubernetes nodes for predictions fault tolerance.. 
    target_name:str, none_type [optional]
         The name of the target for labeling predictions. Required for model type 'inference'. Specifying this value for a model type 'training' will result in an error.. 
    """
    _converter = t.Dict(
        {
            t.Key("class_labels", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("description", optional=True):  t.String(),
            t.Key("desired_memory", optional=True):  t.Int(),
            t.Key("language", optional=True):  t.String(),
            t.Key("maximum_memory", optional=True):  t.Int(),
            t.Key("name", optional=True):  t.String(),
            t.Key("negative_class_label", optional=True):  t.String(),
            t.Key("network_egress_policy", optional=True):  t.String(),
            t.Key("positive_class_label", optional=True):  t.String(),
            t.Key("prediction_threshold", optional=True):  t.Float(),
            t.Key("replicas", optional=True):  t.Int(),
            t.Key("requires_ha", optional=True):  t.Bool(),
            t.Key("target_name", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        class_labels=None,
        description=None,
        desired_memory=None,
        language=None,
        maximum_memory=None,
        name=None,
        negative_class_label=None,
        network_egress_policy=None,
        positive_class_label=None,
        prediction_threshold=None,
        replicas=None,
        requires_ha=None,
        target_name=None,
    ):
        self.class_labels = class_labels
        self.description = description
        self.desired_memory = desired_memory
        self.language = language
        self.maximum_memory = maximum_memory
        self.name = name
        self.negative_class_label = negative_class_label
        self.network_egress_policy = network_egress_policy
        self.positive_class_label = positive_class_label
        self.prediction_threshold = prediction_threshold
        self.replicas = replicas
        self.requires_ha = requires_ha
        self.target_name = target_name

    def __repr__(self):
        return (
            "CustomModelUpdate("
            "class_labels={0.class_labels}, "
            "description={0.description}, "
            "desired_memory={0.desired_memory}, "
            "language={0.language}, "
            "maximum_memory={0.maximum_memory}, "
            "name={0.name}, "
            "negative_class_label={0.negative_class_label}, "
            "network_egress_policy={0.network_egress_policy}, "
            "positive_class_label={0.positive_class_label}, "
            "prediction_threshold={0.prediction_threshold}, "
            "replicas={0.replicas}, "
            "requires_ha={0.requires_ha}, "
            "target_name={0.target_name}, "
        ).format(self)
