#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.required_metadata_value import RequiredMetadataValue

class CustomModelVersionCreateFromRepository(APIObject):
    """
    Attributes
    ----------
    repository_id:str
         The ID of remote repository used to pull sources. This ID can be found using the /api/v2/remoteRepositories/ endpoint.
    base_environment_id:str [optional]
         The base environment to use with this version.. 
    is_major_update:bool [optional]
         If set to true, new major version will created, otherwise minor version will be created..  if omitted the server will use the default value of True
    ref:str [optional]
         Remote reference (branch, commit, etc). Latest, if not specified.. 
    required_metadata:{str: (bool, date, datetime, dict, float, int, list, str, none_type)} [optional]
         Additional parameters required by the execution environment. The required keys are defined by the fieldNames in the base envionment's requiredMetadataKeys. Once set, they cannot be changed. If you to change them, make a new version.. 
    required_metadata_values:[RequiredMetadataValue] [optional]
         Additional parameters required by the execution environment. The required fieldNames are defined by the fieldNames in the base envionment's requiredMetadataKeys.. 
    source_path:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         A remote repository file path to be pulled into a custom model or custom task.. 
    """
    _converter = t.Dict(
        {
            t.Key("repository_id"):  t.String(),
            t.Key("base_environment_id", optional=True):  t.String(),
            t.Key("is_major_update", optional=True):  t.Bool(),
            t.Key("ref", optional=True):  t.String(),
            t.Key("required_metadata", optional=True):  t.Any(),
            t.Key("required_metadata_values", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("source_path", optional=True):  t.Any(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        repository_id,
        base_environment_id=None,
        is_major_update=None,
        ref=None,
        required_metadata=None,
        required_metadata_values=None,
        source_path=None,
    ):
        self.repository_id = repository_id
        self.base_environment_id = base_environment_id
        self.is_major_update = is_major_update
        self.ref = ref
        self.required_metadata = required_metadata
        self.required_metadata_values = required_metadata_values
        self.source_path = source_path

    def __repr__(self):
        return (
            "CustomModelVersionCreateFromRepository("
            "repository_id={0.repository_id}, "
            "base_environment_id={0.base_environment_id}, "
            "is_major_update={0.is_major_update}, "
            "ref={0.ref}, "
            "required_metadata={0.required_metadata}, "
            "required_metadata_values={0.required_metadata_values}, "
            "source_path={0.source_path}, "
        ).format(self)
