#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.dependency_response import DependencyResponse
from datarobot.models.full_api.generated.model.deprecated_custom_model_workspace_item_response import DeprecatedCustomModelWorkspaceItemResponse
from datarobot.models.full_api.generated.model.required_metadata_value import RequiredMetadataValue

class CustomModelVersionResponse(APIObject):
    """
    Attributes
    ----------
    created:str
         ISO-8601 timestamp of when the model was created.
    custom_model_id:str
         the ID of the custom model.
    description:str, none_type
         Description of a custom model version.
    id:str
         the ID of the custom model version created.
    is_frozen:bool
         If the version is frozen and immutable (i.e. it is either deployed or has been edited, causing a newer version to be yielded).
    items:[DeprecatedCustomModelWorkspaceItemResponse]
         List of file items.
    label:str
         A semantic version number of the major and minor version.
    version_major:int
         The major version number, incremented on deployments or larger file changes.
    version_minor:int
         The minor version number, incremented on general file changes.
    base_environment_id:str, none_type [optional]
         The base environment to use with this model version.. 
    base_environment_version_id:str, none_type [optional]
         The base environment version to use with this model version.. 
    dependencies:[DependencyResponse] [optional]
         The parsed dependencies of the custom model version if the version has a valid requirements.txt file.. 
    desired_memory:int, none_type [optional]
         The amount of memory that is expected to be allocated by the custom model.. 
    maximum_memory:int, none_type [optional]
         The maximum memory that might be allocated by the custom-model. If exceeded, the custom-model will be killed. 
    network_egress_policy:str, none_type [optional]
         Network egress policy.. 
    replicas:int, none_type [optional]
         A fixed number of replicas that will be set for the given custom-model.. 
    required_metadata:{str: (bool, date, datetime, dict, float, int, list, str, none_type)} [optional]
         Additional parameters required by the execution environment. The required keys are defined by the fieldNames in the base envionment's requiredMetadataKeys. Once set, they cannot be changed. If you to change them, make a new version.. 
    required_metadata_values:[RequiredMetadataValue] [optional]
         Additional parameters required by the execution environment. The required fieldNames are defined by the fieldNames in the base envionment's requiredMetadataKeys.. 
    requires_ha:bool, none_type [optional]
         Require all custom model replicas to be deployed on different Kubernetes nodes for predictions fault tolerance.. 
    """
    _converter = t.Dict(
        {
            t.Key("created"):  t.String(),
            t.Key("custom_model_id"):  t.String(),
            t.Key("description"):  t.String(),
            t.Key("id"):  t.String(),
            t.Key("is_frozen"):  t.Bool(),
            t.Key("items"):  t.List(t.Dict().allow_extra("*")),
            t.Key("label"):  t.String(),
            t.Key("version_major"):  t.Int(),
            t.Key("version_minor"):  t.Int(),
            t.Key("base_environment_id", optional=True):  t.String(),
            t.Key("base_environment_version_id", optional=True):  t.String(),
            t.Key("dependencies", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("desired_memory", optional=True):  t.Int(),
            t.Key("maximum_memory", optional=True):  t.Int(),
            t.Key("network_egress_policy", optional=True):  t.String(),
            t.Key("replicas", optional=True):  t.Int(),
            t.Key("required_metadata", optional=True):  t.Any(),
            t.Key("required_metadata_values", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("requires_ha", optional=True):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        created,
        custom_model_id,
        description,
        id,
        is_frozen,
        items,
        label,
        version_major,
        version_minor,
        base_environment_id=None,
        base_environment_version_id=None,
        dependencies=None,
        desired_memory=None,
        maximum_memory=None,
        network_egress_policy=None,
        replicas=None,
        required_metadata=None,
        required_metadata_values=None,
        requires_ha=None,
    ):
        self.created = created
        self.custom_model_id = custom_model_id
        self.description = description
        self.id = id
        self.is_frozen = is_frozen
        self.items = items
        self.label = label
        self.version_major = version_major
        self.version_minor = version_minor
        self.base_environment_id = base_environment_id
        self.base_environment_version_id = base_environment_version_id
        self.dependencies = dependencies
        self.desired_memory = desired_memory
        self.maximum_memory = maximum_memory
        self.network_egress_policy = network_egress_policy
        self.replicas = replicas
        self.required_metadata = required_metadata
        self.required_metadata_values = required_metadata_values
        self.requires_ha = requires_ha

    def __repr__(self):
        return (
            "CustomModelVersionResponse("
            "created={0.created}, "
            "custom_model_id={0.custom_model_id}, "
            "description={0.description}, "
            "id={0.id}, "
            "is_frozen={0.is_frozen}, "
            "items={0.items}, "
            "label={0.label}, "
            "version_major={0.version_major}, "
            "version_minor={0.version_minor}, "
            "base_environment_id={0.base_environment_id}, "
            "base_environment_version_id={0.base_environment_version_id}, "
            "dependencies={0.dependencies}, "
            "desired_memory={0.desired_memory}, "
            "maximum_memory={0.maximum_memory}, "
            "network_egress_policy={0.network_egress_policy}, "
            "replicas={0.replicas}, "
            "required_metadata={0.required_metadata}, "
            "required_metadata_values={0.required_metadata_values}, "
            "requires_ha={0.requires_ha}, "
        ).format(self)
