#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class CustomTaskCreate(APIObject):
    """
    Attributes
    ----------
    name:str
         The user-friendly name for the task.
    target_type:str
         The target type of the custom task
    calibrate_predictions:bool [optional]
         Whether model predictions should be calibrated by DataRobot.Only applies to anomaly detection; we recommend this if you have not already included calibration in your model code.Calibration improves the probability estimates of a model, and modifies the predictions of non-probabilistic models to be interpretable as probabilities. This will facilitate comparison to DataRobot models, and give access to ROC curve insights on external data..  if omitted the server will use the default value of True
    description:str [optional]
         The user-friendly description of the task.. 
    language:str [optional]
         Programming language name in which task is written.. 
    """
    _converter = t.Dict(
        {
            t.Key("name"):  t.String(),
            t.Key("target_type"):  t.String(),
            t.Key("calibrate_predictions", optional=True):  t.Bool(),
            t.Key("description", optional=True):  t.String(),
            t.Key("language", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        name,
        target_type,
        calibrate_predictions=None,
        description=None,
        language=None,
    ):
        self.name = name
        self.target_type = target_type
        self.calibrate_predictions = calibrate_predictions
        self.description = description
        self.language = language

    def __repr__(self):
        return (
            "CustomTaskCreate("
            "name={0.name}, "
            "target_type={0.target_type}, "
            "calibrate_predictions={0.calibrate_predictions}, "
            "description={0.description}, "
            "language={0.language}, "
        ).format(self)
