#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.custom_task_version_response import CustomTaskVersionResponse

class CustomTaskResponse(APIObject):
    """
    Attributes
    ----------
    created:str
         ISO-8601 timestamp of when the task was created.
    created_by:str
         The username of the custom task creator.
    custom_model_type:str
         The type of custom task.
    deployments_count:int
         Number of models deployed.
    description:str
         The description of the task.
    id:str
         The ID of the custom task.
    language:str
         The programming language used by the task.
    latest_version:CustomTaskVersionResponse
        
    name:str
         The name of the task.
    target_type:str
         The target type of the custom task.
    updated:str
         ISO-8601 timestamp of when task was last updated.
    calibrate_predictions:bool [optional]
         Determines whether or not predictions should be calibrated by DataRobot. Only applies to anomaly detection.. 
    """
    _converter = t.Dict(
        {
            t.Key("created"):  t.String(),
            t.Key("created_by"):  t.String(),
            t.Key("custom_model_type"):  t.String(),
            t.Key("deployments_count"):  t.Int(),
            t.Key("description"):  t.String(),
            t.Key("id"):  t.String(),
            t.Key("language"):  t.String(),
            t.Key("latest_version"):  t.Any(),
            t.Key("name"):  t.String(),
            t.Key("target_type"):  t.String(),
            t.Key("updated"):  t.String(),
            t.Key("calibrate_predictions", optional=True):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        created,
        created_by,
        custom_model_type,
        deployments_count,
        description,
        id,
        language,
        latest_version,
        name,
        target_type,
        updated,
        calibrate_predictions=None,
    ):
        self.created = created
        self.created_by = created_by
        self.custom_model_type = custom_model_type
        self.deployments_count = deployments_count
        self.description = description
        self.id = id
        self.language = language
        self.latest_version = latest_version
        self.name = name
        self.target_type = target_type
        self.updated = updated
        self.calibrate_predictions = calibrate_predictions

    def __repr__(self):
        return (
            "CustomTaskResponse("
            "created={0.created}, "
            "created_by={0.created_by}, "
            "custom_model_type={0.custom_model_type}, "
            "deployments_count={0.deployments_count}, "
            "description={0.description}, "
            "id={0.id}, "
            "language={0.language}, "
            "latest_version={0.latest_version}, "
            "name={0.name}, "
            "target_type={0.target_type}, "
            "updated={0.updated}, "
            "calibrate_predictions={0.calibrate_predictions}, "
        ).format(self)
