#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.required_metadata_value import RequiredMetadataValue

class CustomTaskVersionMetadataUpdate(APIObject):
    """
    Attributes
    ----------
    description:str [optional]
         New description for the custom task or model.. 
    required_metadata:{str: (bool, date, datetime, dict, float, int, list, str, none_type)} [optional]
         Additional parameters required by the execution environment. The required keys are defined by the fieldNames in the base envionment's requiredMetadataKeys.. 
    required_metadata_values:[RequiredMetadataValue] [optional]
         Additional parameters required by the execution environment. The required fieldNames are defined by the fieldNames in the base envionment's requiredMetadataKeys.. 
    """
    _converter = t.Dict(
        {
            t.Key("description", optional=True):  t.String(),
            t.Key("required_metadata", optional=True):  t.Any(),
            t.Key("required_metadata_values", optional=True):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        description=None,
        required_metadata=None,
        required_metadata_values=None,
    ):
        self.description = description
        self.required_metadata = required_metadata
        self.required_metadata_values = required_metadata_values

    def __repr__(self):
        return (
            "CustomTaskVersionMetadataUpdate("
            "description={0.description}, "
            "required_metadata={0.required_metadata}, "
            "required_metadata_values={0.required_metadata_values}, "
        ).format(self)
