#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.dependency_response import DependencyResponse
from datarobot.models.full_api.generated.model.required_metadata_value import RequiredMetadataValue
from datarobot.models.full_api.generated.model.workspace_item_response import WorkspaceItemResponse

class CustomTaskVersionResponse(APIObject):
    """
    Attributes
    ----------
    created:str
         ISO-8601 timestamp of when the task was created.
    custom_model_id:str
         an alias for customTaskId
    custom_task_id:str
         the ID of the custom task.
    description:str, none_type
         Description of a custom task version.
    id:str
         the ID of the custom model version created.
    is_frozen:bool
         If the version is frozen and immutable (i.e. it is either deployed or has been edited, causing a newer version to be yielded).
    items:[WorkspaceItemResponse]
         List of file items.
    label:str
         A semantic version number of the major and minor version.
    version_major:int
         The major version number, incremented on deployments or larger file changes.
    version_minor:int
         The minor version number, incremented on general file changes.
    base_environment_id:str, none_type [optional]
         The base environment to use with this task version.. 
    base_environment_version_id:str, none_type [optional]
         The base environment version to use with this task version.. 
    dependencies:[DependencyResponse] [optional]
         The parsed dependencies of the custom task version if the version has a valid requirements.txt file.. 
    required_metadata:{str: (bool, date, datetime, dict, float, int, list, str, none_type)} [optional]
         Additional parameters required by the execution environment. The required keys are defined by the fieldNames in the base envionment's requiredMetadataKeys. Once set, they cannot be changed. If you want to change them, make a new version.. 
    required_metadata_values:[RequiredMetadataValue] [optional]
         Additional parameters required by the execution environment. The required fieldNames are defined by the fieldNames in the base envionment's requiredMetadataKeys.. 
    warning:[str] [optional]
         Warnings about the custom task version. 
    """
    _converter = t.Dict(
        {
            t.Key("created"):  t.String(),
            t.Key("custom_model_id"):  t.String(),
            t.Key("custom_task_id"):  t.String(),
            t.Key("description"):  t.String(),
            t.Key("id"):  t.String(),
            t.Key("is_frozen"):  t.Bool(),
            t.Key("items"):  t.List(t.Dict().allow_extra("*")),
            t.Key("label"):  t.String(),
            t.Key("version_major"):  t.Int(),
            t.Key("version_minor"):  t.Int(),
            t.Key("base_environment_id", optional=True):  t.String(),
            t.Key("base_environment_version_id", optional=True):  t.String(),
            t.Key("dependencies", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("required_metadata", optional=True):  t.Any(),
            t.Key("required_metadata_values", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("warning", optional=True):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        created,
        custom_model_id,
        custom_task_id,
        description,
        id,
        is_frozen,
        items,
        label,
        version_major,
        version_minor,
        base_environment_id=None,
        base_environment_version_id=None,
        dependencies=None,
        required_metadata=None,
        required_metadata_values=None,
        warning=None,
    ):
        self.created = created
        self.custom_model_id = custom_model_id
        self.custom_task_id = custom_task_id
        self.description = description
        self.id = id
        self.is_frozen = is_frozen
        self.items = items
        self.label = label
        self.version_major = version_major
        self.version_minor = version_minor
        self.base_environment_id = base_environment_id
        self.base_environment_version_id = base_environment_version_id
        self.dependencies = dependencies
        self.required_metadata = required_metadata
        self.required_metadata_values = required_metadata_values
        self.warning = warning

    def __repr__(self):
        return (
            "CustomTaskVersionResponse("
            "created={0.created}, "
            "custom_model_id={0.custom_model_id}, "
            "custom_task_id={0.custom_task_id}, "
            "description={0.description}, "
            "id={0.id}, "
            "is_frozen={0.is_frozen}, "
            "items={0.items}, "
            "label={0.label}, "
            "version_major={0.version_major}, "
            "version_minor={0.version_minor}, "
            "base_environment_id={0.base_environment_id}, "
            "base_environment_version_id={0.base_environment_version_id}, "
            "dependencies={0.dependencies}, "
            "required_metadata={0.required_metadata}, "
            "required_metadata_values={0.required_metadata_values}, "
            "warning={0.warning}, "
        ).format(self)
