#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.custom_model_short_response import CustomModelShortResponse
from datarobot.models.full_api.generated.model.custom_model_version_short_response import CustomModelVersionShortResponse
from datarobot.models.full_api.generated.model.execution_environment_short_response import ExecutionEnvironmentShortResponse
from datarobot.models.full_api.generated.model.execution_environment_version_short_response import ExecutionEnvironmentVersionShortResponse
from datarobot.models.full_api.generated.model.training_history_entry import TrainingHistoryEntry

class CustomTrainingBlueprintResponse(APIObject):
    """
    Attributes
    ----------
    created_at:str
         ISO-8601 timestamp of when the blueprint was created.
    custom_model:CustomModelShortResponse
        
    custom_model_version:CustomModelVersionShortResponse
        
    execution_environment:ExecutionEnvironmentShortResponse
        
    execution_environment_version:ExecutionEnvironmentVersionShortResponse
        
    target_type:str
         The target type of the training model.
    training_history:[TrainingHistoryEntry]
         List of instances of this blueprint having been trained.
    user_blueprint_id:str
         User Blueprint ID that can be used to train the model.
    """
    _converter = t.Dict(
        {
            t.Key("created_at"):  t.String(),
            t.Key("custom_model"):  t.Any(),
            t.Key("custom_model_version"):  t.Any(),
            t.Key("execution_environment"):  t.Any(),
            t.Key("execution_environment_version"):  t.Any(),
            t.Key("target_type"):  t.String(),
            t.Key("training_history"):  t.List(t.Dict().allow_extra("*")),
            t.Key("user_blueprint_id"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        created_at,
        custom_model,
        custom_model_version,
        execution_environment,
        execution_environment_version,
        target_type,
        training_history,
        user_blueprint_id,
    ):
        self.created_at = created_at
        self.custom_model = custom_model
        self.custom_model_version = custom_model_version
        self.execution_environment = execution_environment
        self.execution_environment_version = execution_environment_version
        self.target_type = target_type
        self.training_history = training_history
        self.user_blueprint_id = user_blueprint_id

    def __repr__(self):
        return (
            "CustomTrainingBlueprintResponse("
            "created_at={0.created_at}, "
            "custom_model={0.custom_model}, "
            "custom_model_version={0.custom_model_version}, "
            "execution_environment={0.execution_environment}, "
            "execution_environment_version={0.execution_environment_version}, "
            "target_type={0.target_type}, "
            "training_history={0.training_history}, "
            "user_blueprint_id={0.user_blueprint_id}, "
        ).format(self)
