#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DataDisparityCreatePayload(APIObject):
    """
    Attributes
    ----------
    compared_class_names:[str]
         An array of classes to calculate data disparity for.
    feature:str
         Feature for which insight is computed.
    """
    _converter = t.Dict(
        {
            t.Key("compared_class_names"):  t.List(t.Dict().allow_extra("*")),
            t.Key("feature"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        compared_class_names,
        feature,
    ):
        self.compared_class_names = compared_class_names
        self.feature = feature

    def __repr__(self):
        return (
            "DataDisparityCreatePayload("
            "compared_class_names={0.compared_class_names}, "
            "feature={0.feature}, "
        ).format(self)
