#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.analyzed_feature import AnalyzedFeature
from datarobot.models.full_api.generated.model.feature_counts import FeatureCounts

class DataDisparityInsights(APIObject):
    """
    Attributes
    ----------
    features:[AnalyzedFeature] [optional]
         A mapping of the feature name to the corresponding values on the graph.. 
    metric:str [optional]
         Metric used to calculate the impact of a feature on data disparity.. 
    protected_feature:str [optional]
         Feature for which insights were computed.. 
    values:[FeatureCounts] [optional]
         Class count details for each class being compared.. 
    """
    _converter = t.Dict(
        {
            t.Key("features", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("metric", optional=True):  t.String(),
            t.Key("protected_feature", optional=True):  t.String(),
            t.Key("values", optional=True):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        features=None,
        metric=None,
        protected_feature=None,
        values=None,
    ):
        self.features = features
        self.metric = metric
        self.protected_feature = protected_feature
        self.values = values

    def __repr__(self):
        return (
            "DataDisparityInsights("
            "features={0.features}, "
            "metric={0.metric}, "
            "protected_feature={0.protected_feature}, "
            "values={0.values}, "
        ).format(self)
