#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DataEngineDataset(APIObject):
    """
    Attributes
    ----------
    alias:str
         Alias to be used as the table name.
    dataset_id:str [optional]
         The ID of the dataset.. 
    dataset_version_id:str [optional]
         The ID of the dataset version.. 
    """
    _converter = t.Dict(
        {
            t.Key("alias"):  t.String(),
            t.Key("dataset_id", optional=True):  t.String(),
            t.Key("dataset_version_id", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        alias,
        dataset_id=None,
        dataset_version_id=None,
    ):
        self.alias = alias
        self.dataset_id = dataset_id
        self.dataset_version_id = dataset_version_id

    def __repr__(self):
        return (
            "DataEngineDataset("
            "alias={0.alias}, "
            "dataset_id={0.dataset_id}, "
            "dataset_version_id={0.dataset_version_id}, "
        ).format(self)
