#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.shap_explanation_response import ShapExplanationResponse

class DataPointResponse(APIObject):
    """
    Attributes
    ----------
    prediction:float
         The output of the model for this row.
    shap_explanation:[ShapExplanationResponse], none_type
         Either ``null`` or an array of up to 10 `ShapleyFeatureContribution` objects. Only rows with the highest anomaly scores have Shapley explanations calculated.
    timestamp:datetime
         ISO-formatted timestamp for the row.
    """
    _converter = t.Dict(
        {
            t.Key("prediction"):  t.Float(),
            t.Key("shap_explanation"):  t.List(t.Dict().allow_extra("*")),
            t.Key("timestamp"):  t.DateTime(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        prediction,
        shap_explanation,
        timestamp,
    ):
        self.prediction = prediction
        self.shap_explanation = shap_explanation
        self.timestamp = timestamp

    def __repr__(self):
        return (
            "DataPointResponse("
            "prediction={0.prediction}, "
            "shap_explanation={0.shap_explanation}, "
            "timestamp={0.timestamp}, "
        ).format(self)
