#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DataQualityWarningsRecord(APIObject):
    """
    Attributes
    ----------
    has_kia_missing_values_in_forecast_window:bool [optional]
         If true, known-in-advance features in this dataset have missing values in the forecast window. Absence of the known-in-advance values can negatively impact prediction quality. Only applies for time series projects.. 
    insufficient_rows_for_evaluating_models:bool [optional]
         If true, the dataset has a target column present indicating it can be used to evaluate model performance but too few rows to be trustworthy in so doing. If false, either it has no target column at all or it has sufficient rows for model evaluation. Only applies for regression, binary classification, multiclass classification projects and time series unsupervised projects.. 
    single_class_actual_value_column:bool [optional]
         If true, actual value column has only one class and such insights as ROC curve can not be calculated. Only applies for binary classification projects or unsupervised projects.. 
    """
    _converter = t.Dict(
        {
            t.Key("has_kia_missing_values_in_forecast_window", optional=True):  t.Bool(),
            t.Key("insufficient_rows_for_evaluating_models", optional=True):  t.Bool(),
            t.Key("single_class_actual_value_column", optional=True):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        has_kia_missing_values_in_forecast_window=None,
        insufficient_rows_for_evaluating_models=None,
        single_class_actual_value_column=None,
    ):
        self.has_kia_missing_values_in_forecast_window = has_kia_missing_values_in_forecast_window
        self.insufficient_rows_for_evaluating_models = insufficient_rows_for_evaluating_models
        self.single_class_actual_value_column = single_class_actual_value_column

    def __repr__(self):
        return (
            "DataQualityWarningsRecord("
            "has_kia_missing_values_in_forecast_window={0.has_kia_missing_values_in_forecast_window}, "
            "insufficient_rows_for_evaluating_models={0.insufficient_rows_for_evaluating_models}, "
            "single_class_actual_value_column={0.single_class_actual_value_column}, "
        ).format(self)
