#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DataRobotAccountOptions(APIObject):
    """
    Attributes
    ----------
    create_dr_portal_account:bool [optional]
         Set to true to include DataRobot Account Portal in the account creation process.. 
    link:bool [optional]
         Set to true to create or link this account to a DR account.. 
    referrer:str [optional]
         Set to indicate the product the user signed up to use(e.g. Paxata) They will be redirected there upon accepting their invite..  if omitted the server will use the default value of "AutoML"
    """
    _converter = t.Dict(
        {
            t.Key("create_dr_portal_account", optional=True):  t.Bool(),
            t.Key("link", optional=True):  t.Bool(),
            t.Key("referrer", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        create_dr_portal_account=None,
        link=None,
        referrer=None,
    ):
        self.create_dr_portal_account = create_dr_portal_account
        self.link = link
        self.referrer = referrer

    def __repr__(self):
        return (
            "DataRobotAccountOptions("
            "create_dr_portal_account={0.create_dr_portal_account}, "
            "link={0.link}, "
            "referrer={0.referrer}, "
        ).format(self)
