#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DataSource(APIObject):
    """
    Attributes
    ----------
    data_store_id:str
         ID of the data store.
    data_store_name:str
         Name of the data store.
    dbtable:str
         Table name of the data source.
    schema:str, none_type
         Schema name of the data source.
    url:str
         URL of the data store.
    catalog:str, none_type [optional]
         Catalog name of the data source.. 
    data_source_id:str [optional]
         ID of the data source.. 
    """
    _converter = t.Dict(
        {
            t.Key("data_store_id"):  t.String(),
            t.Key("data_store_name"):  t.String(),
            t.Key("dbtable"):  t.String(),
            t.Key("schema"):  t.String(),
            t.Key("url"):  t.String(),
            t.Key("catalog", optional=True):  t.String(),
            t.Key("data_source_id", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        data_store_id,
        data_store_name,
        dbtable,
        schema,
        url,
        catalog=None,
        data_source_id=None,
    ):
        self.data_store_id = data_store_id
        self.data_store_name = data_store_name
        self.dbtable = dbtable
        self.schema = schema
        self.url = url
        self.catalog = catalog
        self.data_source_id = data_source_id

    def __repr__(self):
        return (
            "DataSource("
            "data_store_id={0.data_store_id}, "
            "data_store_name={0.data_store_name}, "
            "dbtable={0.dbtable}, "
            "schema={0.schema}, "
            "url={0.url}, "
            "catalog={0.catalog}, "
            "data_source_id={0.data_source_id}, "
        ).format(self)
