#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DataSourceDescribePermissionsResponse(APIObject):
    """
    Attributes
    ----------
    can_create_predictions:bool
         True if the user can create predictions from the data source.
    can_create_project:bool
         True if the user can create project from the data source.
    can_delete:bool
         True if the user can delete the data source.
    can_edit:bool
         True if the user can edit data source info.
    can_set_roles:[str]
         Roles the user can grant or revoke from other users, groups, or organizations.
    can_share:bool
         True if the user can share the data source.
    can_view:bool
         True if the user can view data source info.
    data_source_id:str
         The ID of the data source.
    user_id:str
         The ID of the user identified by username.
    username:str
         `username` of a user with access to this data source.
    """
    _converter = t.Dict(
        {
            t.Key("can_create_predictions"):  t.Bool(),
            t.Key("can_create_project"):  t.Bool(),
            t.Key("can_delete"):  t.Bool(),
            t.Key("can_edit"):  t.Bool(),
            t.Key("can_set_roles"):  t.List(t.Dict().allow_extra("*")),
            t.Key("can_share"):  t.Bool(),
            t.Key("can_view"):  t.Bool(),
            t.Key("data_source_id"):  t.String(),
            t.Key("user_id"):  t.String(),
            t.Key("username"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        can_create_predictions,
        can_create_project,
        can_delete,
        can_edit,
        can_set_roles,
        can_share,
        can_view,
        data_source_id,
        user_id,
        username,
    ):
        self.can_create_predictions = can_create_predictions
        self.can_create_project = can_create_project
        self.can_delete = can_delete
        self.can_edit = can_edit
        self.can_set_roles = can_set_roles
        self.can_share = can_share
        self.can_view = can_view
        self.data_source_id = data_source_id
        self.user_id = user_id
        self.username = username

    def __repr__(self):
        return (
            "DataSourceDescribePermissionsResponse("
            "can_create_predictions={0.can_create_predictions}, "
            "can_create_project={0.can_create_project}, "
            "can_delete={0.can_delete}, "
            "can_edit={0.can_edit}, "
            "can_set_roles={0.can_set_roles}, "
            "can_share={0.can_share}, "
            "can_view={0.can_view}, "
            "data_source_id={0.data_source_id}, "
            "user_id={0.user_id}, "
            "username={0.username}, "
        ).format(self)
