#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DataSourceRetrieveResponse(APIObject):
    """
    Attributes
    ----------
    canonical_name:str
         Data source canonical name.
    creator:str
         ID of the user who created the data source.
    id:str
         Data source ID.
    params:bool, date, datetime, dict, float, int, list, str, none_type
         Data source configuration.
    role:str
         Role of the user making the request on this data source.
    type:str
         Data source type.
    updated:str
         ISO 8601-formatted date/time of the data source update.
    """
    _converter = t.Dict(
        {
            t.Key("canonical_name"):  t.String(),
            t.Key("creator"):  t.String(),
            t.Key("id"):  t.String(),
            t.Key("params"):  t.Any(),
            t.Key("role"):  t.String(),
            t.Key("type"):  t.String(),
            t.Key("updated"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        canonical_name,
        creator,
        id,
        params,
        role,
        type,
        updated,
    ):
        self.canonical_name = canonical_name
        self.creator = creator
        self.id = id
        self.params = params
        self.role = role
        self.type = type
        self.updated = updated

    def __repr__(self):
        return (
            "DataSourceRetrieveResponse("
            "canonical_name={0.canonical_name}, "
            "creator={0.creator}, "
            "id={0.id}, "
            "params={0.params}, "
            "role={0.role}, "
            "type={0.type}, "
            "updated={0.updated}, "
        ).format(self)
