#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DataStoreCredentialsWithCredentialsTypeSupport(APIObject):
    """
    Attributes
    ----------
    credential_data:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         Type of credentials to use with the data store.. 
    credential_id:str [optional]
         ID of the set of credentials to use instead of username and password.. 
    password:str [optional]
         Password for data store authentication.. 
    use_kerberos:bool [optional]
         Whether to use Kerberos for data store authentication..  if omitted the server will use the default value of False
    user:str [optional]
         Username for data store authentication.. 
    """
    _converter = t.Dict(
        {
            t.Key("credential_data", optional=True):  t.Any(),
            t.Key("credential_id", optional=True):  t.String(),
            t.Key("password", optional=True):  t.String(),
            t.Key("use_kerberos", optional=True):  t.Bool(),
            t.Key("user", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        credential_data=None,
        credential_id=None,
        password=None,
        use_kerberos=None,
        user=None,
    ):
        self.credential_data = credential_data
        self.credential_id = credential_id
        self.password = password
        self.use_kerberos = use_kerberos
        self.user = user

    def __repr__(self):
        return (
            "DataStoreCredentialsWithCredentialsTypeSupport("
            "credential_data={0.credential_data}, "
            "credential_id={0.credential_id}, "
            "password={0.password}, "
            "use_kerberos={0.use_kerberos}, "
            "user={0.user}, "
        ).format(self)
