#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DataStoreDescribePermissionsResponse(APIObject):
    """
    Attributes
    ----------
    can_create_data_source:bool
         True if the user can create data source from this data store.
    can_delete:bool
         True if the user can delete the data store.
    can_edit:bool
         True if the user can edit data store info.
    can_scan_database:bool
         True if the user can scan data store database.
    can_set_roles:[str]
         Roles the user can grant or revoke from other users, groups, or organizations.
    can_share:bool
         True if the user can share the data store.
    can_test_connection:bool
         True if the user can test data store database connection.
    can_view:bool
         True if the user can view data store info.
    data_store_id:str
         The ID of the data store.
    user_id:str
         The ID of the user identified by username.
    username:str
         `username` of a user with access to this data store.
    """
    _converter = t.Dict(
        {
            t.Key("can_create_data_source"):  t.Bool(),
            t.Key("can_delete"):  t.Bool(),
            t.Key("can_edit"):  t.Bool(),
            t.Key("can_scan_database"):  t.Bool(),
            t.Key("can_set_roles"):  t.List(t.Dict().allow_extra("*")),
            t.Key("can_share"):  t.Bool(),
            t.Key("can_test_connection"):  t.Bool(),
            t.Key("can_view"):  t.Bool(),
            t.Key("data_store_id"):  t.String(),
            t.Key("user_id"):  t.String(),
            t.Key("username"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        can_create_data_source,
        can_delete,
        can_edit,
        can_scan_database,
        can_set_roles,
        can_share,
        can_test_connection,
        can_view,
        data_store_id,
        user_id,
        username,
    ):
        self.can_create_data_source = can_create_data_source
        self.can_delete = can_delete
        self.can_edit = can_edit
        self.can_scan_database = can_scan_database
        self.can_set_roles = can_set_roles
        self.can_share = can_share
        self.can_test_connection = can_test_connection
        self.can_view = can_view
        self.data_store_id = data_store_id
        self.user_id = user_id
        self.username = username

    def __repr__(self):
        return (
            "DataStoreDescribePermissionsResponse("
            "can_create_data_source={0.can_create_data_source}, "
            "can_delete={0.can_delete}, "
            "can_edit={0.can_edit}, "
            "can_scan_database={0.can_scan_database}, "
            "can_set_roles={0.can_set_roles}, "
            "can_share={0.can_share}, "
            "can_test_connection={0.can_test_connection}, "
            "can_view={0.can_view}, "
            "data_store_id={0.data_store_id}, "
            "user_id={0.user_id}, "
            "username={0.username}, "
        ).format(self)
