#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DataStoreRetrieveResponse(APIObject):
    """
    Attributes
    ----------
    canonical_name:str
         The user-friendly name of the data store.
    creator:str
         ID of the user who created the data store.
    id:str
         Data store ID.
    params:bool, date, datetime, dict, float, int, list, str, none_type
         Data store configuration.
    role:str
         Role of the user making the request on this data store.
    type:str
         Data store type.
    updated:str
         ISO 8601-formatted date/time of the data store update.
    associated_auth_types:[str] [optional]
         Supported authentication types for the JDBC configuration.. 
    """
    _converter = t.Dict(
        {
            t.Key("canonical_name"):  t.String(),
            t.Key("creator"):  t.String(),
            t.Key("id"):  t.String(),
            t.Key("params"):  t.Any(),
            t.Key("role"):  t.String(),
            t.Key("type"):  t.String(),
            t.Key("updated"):  t.String(),
            t.Key("associated_auth_types", optional=True):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        canonical_name,
        creator,
        id,
        params,
        role,
        type,
        updated,
        associated_auth_types=None,
    ):
        self.canonical_name = canonical_name
        self.creator = creator
        self.id = id
        self.params = params
        self.role = role
        self.type = type
        self.updated = updated
        self.associated_auth_types = associated_auth_types

    def __repr__(self):
        return (
            "DataStoreRetrieveResponse("
            "canonical_name={0.canonical_name}, "
            "creator={0.creator}, "
            "id={0.id}, "
            "params={0.params}, "
            "role={0.role}, "
            "type={0.type}, "
            "updated={0.updated}, "
            "associated_auth_types={0.associated_auth_types}, "
        ).format(self)
