#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DataStoreSchemasList(APIObject):
    """
    Attributes
    ----------
    catalog:str
         Name of the catalog associated with the schemas. If more than one catalog is queried, the returned value will be the catalog name for the first record returned.
    catalogs:[str]
         List of catalogs associated with each retrieved schema. If no catalog is found, this value is null.
    schemas:[str]
         List of schemas available in the data store.
    """
    _converter = t.Dict(
        {
            t.Key("catalog"):  t.String(),
            t.Key("catalogs"):  t.List(t.Dict().allow_extra("*")),
            t.Key("schemas"):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        catalog,
        catalogs,
        schemas,
    ):
        self.catalog = catalog
        self.catalogs = catalogs
        self.schemas = schemas

    def __repr__(self):
        return (
            "DataStoreSchemasList("
            "catalog={0.catalog}, "
            "catalogs={0.catalogs}, "
            "schemas={0.schemas}, "
        ).format(self)
