#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.table_description import TableDescription

class DataStoreTablesList(APIObject):
    """
    Attributes
    ----------
    catalog:str
         Catalog associated with schemas.
    tables:[TableDescription]
         List of tables in the data store.
    """
    _converter = t.Dict(
        {
            t.Key("catalog"):  t.String(),
            t.Key("tables"):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        catalog,
        tables,
    ):
        self.catalog = catalog
        self.tables = tables

    def __repr__(self):
        return (
            "DataStoreTablesList("
            "catalog={0.catalog}, "
            "tables={0.tables}, "
        ).format(self)
