#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DatasetAccessControlResponse(APIObject):
    """
    Attributes
    ----------
    can_share:bool
         True if this user can share with other users
    can_use_data:bool
         True if the user can view, download and process data (use to create projects, predictions, etc)
    role:str
         The role of the user on this data source.
    user_full_name:str
         The full name of a user with access to this dataset. If the full name is not available, username is returned instead.
    username:str
         `username` of a user with access to this dataset.
    """
    _converter = t.Dict(
        {
            t.Key("can_share"):  t.Bool(),
            t.Key("can_use_data"):  t.Bool(),
            t.Key("role"):  t.String(),
            t.Key("user_full_name"):  t.String(),
            t.Key("username"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        can_share,
        can_use_data,
        role,
        user_full_name,
        username,
    ):
        self.can_share = can_share
        self.can_use_data = can_use_data
        self.role = role
        self.user_full_name = user_full_name
        self.username = username

    def __repr__(self):
        return (
            "DatasetAccessControlResponse("
            "can_share={0.can_share}, "
            "can_use_data={0.can_use_data}, "
            "role={0.role}, "
            "user_full_name={0.user_full_name}, "
            "username={0.username}, "
        ).format(self)
