#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DatasetAccessInner(APIObject):
    """
    Attributes
    ----------
    role:str
         the role to grant to the user, or \"\" (empty string) to remove the users access
    username:str
         username of the user to update the access role for.
    can_share:bool [optional]
         whether the user should be able to share with other users. If true, the user will be able to grant any role up to and including their own to other users. If `role` is empty `canShare` is ignored.. 
    can_use_data:bool [optional]
         Whether the user should be able to view, download and process data (use to create projects, predictions, etc). For OWNER `canUseData` is always True. If `role` is empty `canUseData` is ignored.. 
    """
    _converter = t.Dict(
        {
            t.Key("role"):  t.String(),
            t.Key("username"):  t.String(),
            t.Key("can_share", optional=True):  t.Bool(),
            t.Key("can_use_data", optional=True):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        role,
        username,
        can_share=None,
        can_use_data=None,
    ):
        self.role = role
        self.username = username
        self.can_share = can_share
        self.can_use_data = can_use_data

    def __repr__(self):
        return (
            "DatasetAccessInner("
            "role={0.role}, "
            "username={0.username}, "
            "can_share={0.can_share}, "
            "can_use_data={0.can_use_data}, "
        ).format(self)
