#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.dataset_access_inner import DatasetAccessInner

class DatasetAccessSet(APIObject):
    """
    Attributes
    ----------
    data:[DatasetAccessInner]
         array of DatasetAccessControl objects.
    apply_grant_to_linked_objects:bool [optional]
         If true for any users being granted access to the dataset, grant the user read access to any linked objects such as DataSources and DataStores that may be used by this dataset. Ignored if no such objects are relevant for dataset. Will not result in access being lowered for a user if the user already has higher access to linked objects than read access. However, if the target user does not have sharing permissions to the linked object, they will be given sharing access without lowering existing permissions. May result in an error if user making call does not have sufficient permissions to complete grant. Default value is false..  if omitted the server will use the default value of False
    """
    _converter = t.Dict(
        {
            t.Key("data"):  t.List(t.Dict().allow_extra("*")),
            t.Key("apply_grant_to_linked_objects", optional=True):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        data,
        apply_grant_to_linked_objects=None,
    ):
        self.data = data
        self.apply_grant_to_linked_objects = apply_grant_to_linked_objects

    def __repr__(self):
        return (
            "DatasetAccessSet("
            "data={0.data}, "
            "apply_grant_to_linked_objects={0.apply_grant_to_linked_objects}, "
        ).format(self)
