#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DatasetCreateFromWorkspaceState(APIObject):
    """
    Attributes
    ----------
    workspace_state_id:str
         ID of the workspace state to use as the source of data.
    credentials:str [optional]
         JDBC credentials.. 
    dataset_name:str [optional]
         Custom name for the created dataset.. 
    do_snapshot:bool [optional]
         If true, create a snapshot dataset; if false, create a remote dataset. Creating snapshots from non-file sources requires an additional permission, `Enable Create Snapshot Data Source`.. 
    """
    _converter = t.Dict(
        {
            t.Key("workspace_state_id"):  t.String(),
            t.Key("credentials", optional=True):  t.String(),
            t.Key("dataset_name", optional=True):  t.String(),
            t.Key("do_snapshot", optional=True):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        workspace_state_id,
        credentials=None,
        dataset_name=None,
        do_snapshot=None,
    ):
        self.workspace_state_id = workspace_state_id
        self.credentials = credentials
        self.dataset_name = dataset_name
        self.do_snapshot = do_snapshot

    def __repr__(self):
        return (
            "DatasetCreateFromWorkspaceState("
            "workspace_state_id={0.workspace_state_id}, "
            "credentials={0.credentials}, "
            "dataset_name={0.dataset_name}, "
            "do_snapshot={0.do_snapshot}, "
        ).format(self)
