#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DatasetDefinition(APIObject):
    """
    Attributes
    ----------
    catalog_id:str
         ID of the catalog item.
    catalog_version_id:str
         ID of the catalog item version.
    identifier:str
         Short name of the dataset (used directly as part of the generated feature names).
    feature_list_id:str, none_type [optional]
         ID of the feature list. This decides which columns in the dataset are used for feature generation.. 
    primary_temporal_key:str, none_type [optional]
         Name of the column indicating time of record creation.. 
    snapshot_policy:str [optional]
         Policy for using dataset snapshots when creating a project or making predictions. Must be one of the following values: 'specified': Use specific snapshot specified by catalogVersionId. 'latest': Use latest snapshot from the same catalog item. 'dynamic': Get data from the source (only applicable for JDBC datasets).. 
    """
    _converter = t.Dict(
        {
            t.Key("catalog_id"):  t.String(),
            t.Key("catalog_version_id"):  t.String(),
            t.Key("identifier"):  t.String(),
            t.Key("feature_list_id", optional=True):  t.String(),
            t.Key("primary_temporal_key", optional=True):  t.String(),
            t.Key("snapshot_policy", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        catalog_id,
        catalog_version_id,
        identifier,
        feature_list_id=None,
        primary_temporal_key=None,
        snapshot_policy=None,
    ):
        self.catalog_id = catalog_id
        self.catalog_version_id = catalog_version_id
        self.identifier = identifier
        self.feature_list_id = feature_list_id
        self.primary_temporal_key = primary_temporal_key
        self.snapshot_policy = snapshot_policy

    def __repr__(self):
        return (
            "DatasetDefinition("
            "catalog_id={0.catalog_id}, "
            "catalog_version_id={0.catalog_version_id}, "
            "identifier={0.identifier}, "
            "feature_list_id={0.feature_list_id}, "
            "primary_temporal_key={0.primary_temporal_key}, "
            "snapshot_policy={0.snapshot_policy}, "
        ).format(self)
