#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.data_source import DataSource

class DatasetDefinitionResponse(APIObject):
    """
    Attributes
    ----------
    catalog_id:str, none_type
         ID of the catalog item.
    catalog_version_id:str
         ID of the catalog item version.
    feature_list_id:str
         ID of the feature list. This decides which columns in the dataset are used for feature generation.
    identifier:str
         Short name of the dataset (used directly as part of the generated feature names).
    snapshot_policy:str
         Policy for using dataset snapshots when creating a project or making predictions. Must be one of the following values: 'specified': Use specific snapshot specified by catalogVersionId. 'latest': Use latest snapshot from the same catalog item. 'dynamic': Get data from the source (only applicable for JDBC datasets).
    data_source:DataSource [optional]
         
    data_sources:[DataSource], none_type [optional]
         Data source details for a JDBC dataset. 
    feature_lists:[str] [optional]
         List of available feature list ids for the dataset. 
    is_deleted:bool, none_type [optional]
         Is this dataset deleted?. 
    original_identifier:str, none_type [optional]
         Original identifier of the dataset if it was updated to resolve name conflicts.. 
    primary_temporal_key:str, none_type [optional]
         Name of the column indicating time of record creation.. 
    """
    _converter = t.Dict(
        {
            t.Key("catalog_id"):  t.String(),
            t.Key("catalog_version_id"):  t.String(),
            t.Key("feature_list_id"):  t.String(),
            t.Key("identifier"):  t.String(),
            t.Key("snapshot_policy"):  t.String(),
            t.Key("data_source", optional=True):  t.Any(),
            t.Key("data_sources", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("feature_lists", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("is_deleted", optional=True):  t.Bool(),
            t.Key("original_identifier", optional=True):  t.String(),
            t.Key("primary_temporal_key", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        catalog_id,
        catalog_version_id,
        feature_list_id,
        identifier,
        snapshot_policy,
        data_source=None,
        data_sources=None,
        feature_lists=None,
        is_deleted=None,
        original_identifier=None,
        primary_temporal_key=None,
    ):
        self.catalog_id = catalog_id
        self.catalog_version_id = catalog_version_id
        self.feature_list_id = feature_list_id
        self.identifier = identifier
        self.snapshot_policy = snapshot_policy
        self.data_source = data_source
        self.data_sources = data_sources
        self.feature_lists = feature_lists
        self.is_deleted = is_deleted
        self.original_identifier = original_identifier
        self.primary_temporal_key = primary_temporal_key

    def __repr__(self):
        return (
            "DatasetDefinitionResponse("
            "catalog_id={0.catalog_id}, "
            "catalog_version_id={0.catalog_version_id}, "
            "feature_list_id={0.feature_list_id}, "
            "identifier={0.identifier}, "
            "snapshot_policy={0.snapshot_policy}, "
            "data_source={0.data_source}, "
            "data_sources={0.data_sources}, "
            "feature_lists={0.feature_lists}, "
            "is_deleted={0.is_deleted}, "
            "original_identifier={0.original_identifier}, "
            "primary_temporal_key={0.primary_temporal_key}, "
        ).format(self)
