#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DatasetDescribePermissionsResponse(APIObject):
    """
    Attributes
    ----------
    can_create_featurelist:bool
         True if the user can create a new featurelist for this dataset.
    can_delete_dataset:bool
         True if the user can delete dataset.
    can_download_dataset_data:bool
         True if the user can download data.
    can_get_catalog_item_info:bool
         True if the user can view catalog info.
    can_get_dataset_info:bool
         True if the user can view dataset info.
    can_get_dataset_permissions:bool
         True if the user can view dataset permissions.
    can_get_feature_info:bool
         True if the user can retrieve feature info of dataset.
    can_get_featurelists:bool
         True if the user can view featurelist for this dataset.
    can_patch_catalog_info:bool
         True if the user can modify catalog info.
    can_patch_dataset_aliases:bool
         True if the user can modify dataset feature aliases.
    can_patch_dataset_info:bool
         True if the user can modify dataset info.
    can_patch_dataset_permissions:bool
         True if the user can modify dataset permissions.
    can_patch_featurelists:bool
         True if the user can modify featurelists for this dataset.
    can_post_dataset:bool
         True if the user can create a new dataset.
    can_reload_dataset:bool
         True if the user can reload dataset.
    can_share_dataset:bool
         True if the user can share the dataset.
    can_snapshot_dataset:bool
         True if the user can save snapshot of dataset.
    can_undelete_dataset:bool
         True if the user can undelete dataset.
    can_use_dataset_data:bool
         True if the user can use dataset data to create projects, train custom models or provide predictions.
    can_use_featurelists:bool
         True if the user can use featurelists for this dataset. (for project creation)
    dataset_id:str
         The ID of the dataset.
    uid:str
         The ID of the user identified by username.
    username:str
         `username` of a user with access to this dataset.
    """
    _converter = t.Dict(
        {
            t.Key("can_create_featurelist"):  t.Bool(),
            t.Key("can_delete_dataset"):  t.Bool(),
            t.Key("can_download_dataset_data"):  t.Bool(),
            t.Key("can_get_catalog_item_info"):  t.Bool(),
            t.Key("can_get_dataset_info"):  t.Bool(),
            t.Key("can_get_dataset_permissions"):  t.Bool(),
            t.Key("can_get_feature_info"):  t.Bool(),
            t.Key("can_get_featurelists"):  t.Bool(),
            t.Key("can_patch_catalog_info"):  t.Bool(),
            t.Key("can_patch_dataset_aliases"):  t.Bool(),
            t.Key("can_patch_dataset_info"):  t.Bool(),
            t.Key("can_patch_dataset_permissions"):  t.Bool(),
            t.Key("can_patch_featurelists"):  t.Bool(),
            t.Key("can_post_dataset"):  t.Bool(),
            t.Key("can_reload_dataset"):  t.Bool(),
            t.Key("can_share_dataset"):  t.Bool(),
            t.Key("can_snapshot_dataset"):  t.Bool(),
            t.Key("can_undelete_dataset"):  t.Bool(),
            t.Key("can_use_dataset_data"):  t.Bool(),
            t.Key("can_use_featurelists"):  t.Bool(),
            t.Key("dataset_id"):  t.String(),
            t.Key("uid"):  t.String(),
            t.Key("username"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        can_create_featurelist,
        can_delete_dataset,
        can_download_dataset_data,
        can_get_catalog_item_info,
        can_get_dataset_info,
        can_get_dataset_permissions,
        can_get_feature_info,
        can_get_featurelists,
        can_patch_catalog_info,
        can_patch_dataset_aliases,
        can_patch_dataset_info,
        can_patch_dataset_permissions,
        can_patch_featurelists,
        can_post_dataset,
        can_reload_dataset,
        can_share_dataset,
        can_snapshot_dataset,
        can_undelete_dataset,
        can_use_dataset_data,
        can_use_featurelists,
        dataset_id,
        uid,
        username,
    ):
        self.can_create_featurelist = can_create_featurelist
        self.can_delete_dataset = can_delete_dataset
        self.can_download_dataset_data = can_download_dataset_data
        self.can_get_catalog_item_info = can_get_catalog_item_info
        self.can_get_dataset_info = can_get_dataset_info
        self.can_get_dataset_permissions = can_get_dataset_permissions
        self.can_get_feature_info = can_get_feature_info
        self.can_get_featurelists = can_get_featurelists
        self.can_patch_catalog_info = can_patch_catalog_info
        self.can_patch_dataset_aliases = can_patch_dataset_aliases
        self.can_patch_dataset_info = can_patch_dataset_info
        self.can_patch_dataset_permissions = can_patch_dataset_permissions
        self.can_patch_featurelists = can_patch_featurelists
        self.can_post_dataset = can_post_dataset
        self.can_reload_dataset = can_reload_dataset
        self.can_share_dataset = can_share_dataset
        self.can_snapshot_dataset = can_snapshot_dataset
        self.can_undelete_dataset = can_undelete_dataset
        self.can_use_dataset_data = can_use_dataset_data
        self.can_use_featurelists = can_use_featurelists
        self.dataset_id = dataset_id
        self.uid = uid
        self.username = username

    def __repr__(self):
        return (
            "DatasetDescribePermissionsResponse("
            "can_create_featurelist={0.can_create_featurelist}, "
            "can_delete_dataset={0.can_delete_dataset}, "
            "can_download_dataset_data={0.can_download_dataset_data}, "
            "can_get_catalog_item_info={0.can_get_catalog_item_info}, "
            "can_get_dataset_info={0.can_get_dataset_info}, "
            "can_get_dataset_permissions={0.can_get_dataset_permissions}, "
            "can_get_feature_info={0.can_get_feature_info}, "
            "can_get_featurelists={0.can_get_featurelists}, "
            "can_patch_catalog_info={0.can_patch_catalog_info}, "
            "can_patch_dataset_aliases={0.can_patch_dataset_aliases}, "
            "can_patch_dataset_info={0.can_patch_dataset_info}, "
            "can_patch_dataset_permissions={0.can_patch_dataset_permissions}, "
            "can_patch_featurelists={0.can_patch_featurelists}, "
            "can_post_dataset={0.can_post_dataset}, "
            "can_reload_dataset={0.can_reload_dataset}, "
            "can_share_dataset={0.can_share_dataset}, "
            "can_snapshot_dataset={0.can_snapshot_dataset}, "
            "can_undelete_dataset={0.can_undelete_dataset}, "
            "can_use_dataset_data={0.can_use_dataset_data}, "
            "can_use_featurelists={0.can_use_featurelists}, "
            "dataset_id={0.dataset_id}, "
            "uid={0.uid}, "
            "username={0.username}, "
        ).format(self)
