#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DatasetFeatureResponse(APIObject):
    """
    Attributes
    ----------
    dataset_id:str
         The ID of the dataset the feature belongs to
    dataset_version_id:str
         The ID of the dataset version the feature belongs to.
    date_format:str, none_type
         The date format string for how this feature was interpreted (or null if not a date feature). If not null, it will be compatible with https://docs.python.org/2/library/time.html#time.strftime .
    feature_type:str
         Feature type.
    id:int
         The number of the column in the dataset.
    name:str
         Feature name
    is_zero_inflated:bool, none_type [optional]
         whether feature has an excessive number of zeros. 
    key_summary:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         Per key summaries for Summarized Categorical or Multicategorical columns. 
    low_information:bool [optional]
         Whether feature has too few values to be informative.. 
    max:float, none_type [optional]
         Maximum value of the EDA sample of the feature.. 
    mean:float, none_type [optional]
         Arithmetic mean of the EDA sample of the feature.. 
    median:float, none_type [optional]
         Median of the EDA sample of the feature.. 
    min:float, none_type [optional]
         Minimum value of the EDA sample of the feature.. 
    na_count:int, none_type [optional]
         Number of missing values.. 
    std_dev:float, none_type [optional]
         Standard deviation of EDA sample of the feature.. 
    time_series_eligibility_reason:str, none_type [optional]
         why the feature is ineligible for time series projects, or 'suitable' if it is eligible.. 
    time_series_eligibility_reason_aggregation:str, none_type [optional]
         why the feature is ineligible for aggregation, or 'suitable' if it is eligible.. 
    time_series_eligible:bool [optional]
         whether this feature can be used as a datetime partitioning feature for time series projects.  Only sufficiently regular date features can be selected as the datetime feature for time series projects.  Always false for non-date features. Date features that cannot be used in datetime partitioning for a time series project may be eligible for an OTV project, which has less stringent requirements.. 
    time_series_eligible_aggregation:bool [optional]
         whether this feature can be used as a datetime feature for aggregationfor time series data prep.  Always false for non-date features.. 
    time_step:int, none_type [optional]
         The minimum time step that can be used to specify time series windows.  The units for this value are the ``timeUnit``.  When specifying windows for time series projects, all windows must have durations that are integer multiples of this number. Only present for date features that are eligible for time series projects and null otherwise.. 
    time_step_aggregation:int, none_type [optional]
         The minimum time step that can be used to aggregate using this feature for time series data prep. The units for this value are the ``timeUnit``.  Only present for date features that are eligible for aggregation in time series data prep and null otherwise.. 
    time_unit:str, none_type [optional]
         The unit for the interval between values of this feature, e.g. DAY, MONTH, HOUR.  When specifying windows for time series projects, the windows are expressed in terms of this unit.  Only present for date features eligible for time series projects, and null otherwise.. 
    time_unit_aggregation:str, none_type [optional]
         The unit for the interval between values of this feature, e.g. DAY, MONTH, HOUR.  Only present for date features eligible for aggregation, and null otherwise.. 
    unique_count:int, none_type [optional]
         Number of unique values.. 
    """
    _converter = t.Dict(
        {
            t.Key("dataset_id"):  t.String(),
            t.Key("dataset_version_id"):  t.String(),
            t.Key("date_format"):  t.String(),
            t.Key("feature_type"):  t.String(),
            t.Key("id"):  t.Int(),
            t.Key("name"):  t.String(),
            t.Key("is_zero_inflated", optional=True):  t.Bool(),
            t.Key("key_summary", optional=True):  t.Any(),
            t.Key("low_information", optional=True):  t.Bool(),
            t.Key("max", optional=True):  t.Float(),
            t.Key("mean", optional=True):  t.Float(),
            t.Key("median", optional=True):  t.Float(),
            t.Key("min", optional=True):  t.Float(),
            t.Key("na_count", optional=True):  t.Int(),
            t.Key("std_dev", optional=True):  t.Float(),
            t.Key("time_series_eligibility_reason", optional=True):  t.String(),
            t.Key("time_series_eligibility_reason_aggregation", optional=True):  t.String(),
            t.Key("time_series_eligible", optional=True):  t.Bool(),
            t.Key("time_series_eligible_aggregation", optional=True):  t.Bool(),
            t.Key("time_step", optional=True):  t.Int(),
            t.Key("time_step_aggregation", optional=True):  t.Int(),
            t.Key("time_unit", optional=True):  t.String(),
            t.Key("time_unit_aggregation", optional=True):  t.String(),
            t.Key("unique_count", optional=True):  t.Int(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        dataset_id,
        dataset_version_id,
        date_format,
        feature_type,
        id,
        name,
        is_zero_inflated=None,
        key_summary=None,
        low_information=None,
        max=None,
        mean=None,
        median=None,
        min=None,
        na_count=None,
        std_dev=None,
        time_series_eligibility_reason=None,
        time_series_eligibility_reason_aggregation=None,
        time_series_eligible=None,
        time_series_eligible_aggregation=None,
        time_step=None,
        time_step_aggregation=None,
        time_unit=None,
        time_unit_aggregation=None,
        unique_count=None,
    ):
        self.dataset_id = dataset_id
        self.dataset_version_id = dataset_version_id
        self.date_format = date_format
        self.feature_type = feature_type
        self.id = id
        self.name = name
        self.is_zero_inflated = is_zero_inflated
        self.key_summary = key_summary
        self.low_information = low_information
        self.max = max
        self.mean = mean
        self.median = median
        self.min = min
        self.na_count = na_count
        self.std_dev = std_dev
        self.time_series_eligibility_reason = time_series_eligibility_reason
        self.time_series_eligibility_reason_aggregation = time_series_eligibility_reason_aggregation
        self.time_series_eligible = time_series_eligible
        self.time_series_eligible_aggregation = time_series_eligible_aggregation
        self.time_step = time_step
        self.time_step_aggregation = time_step_aggregation
        self.time_unit = time_unit
        self.time_unit_aggregation = time_unit_aggregation
        self.unique_count = unique_count

    def __repr__(self):
        return (
            "DatasetFeatureResponse("
            "dataset_id={0.dataset_id}, "
            "dataset_version_id={0.dataset_version_id}, "
            "date_format={0.date_format}, "
            "feature_type={0.feature_type}, "
            "id={0.id}, "
            "name={0.name}, "
            "is_zero_inflated={0.is_zero_inflated}, "
            "key_summary={0.key_summary}, "
            "low_information={0.low_information}, "
            "max={0.max}, "
            "mean={0.mean}, "
            "median={0.median}, "
            "min={0.min}, "
            "na_count={0.na_count}, "
            "std_dev={0.std_dev}, "
            "time_series_eligibility_reason={0.time_series_eligibility_reason}, "
            "time_series_eligibility_reason_aggregation={0.time_series_eligibility_reason_aggregation}, "
            "time_series_eligible={0.time_series_eligible}, "
            "time_series_eligible_aggregation={0.time_series_eligible_aggregation}, "
            "time_step={0.time_step}, "
            "time_step_aggregation={0.time_step_aggregation}, "
            "time_unit={0.time_unit}, "
            "time_unit_aggregation={0.time_unit_aggregation}, "
            "unique_count={0.unique_count}, "
        ).format(self)
