#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DatasetFeaturelistResponse(APIObject):
    """
    Attributes
    ----------
    created_by:str
         `username` of the user who created the dataset.
    creation_date:datetime
         the ISO 8601 formatted date and time when the dataset was created.
    dataset_id:str
         The ID of the dataset.
    dataset_version_id:str, none_type
         The ID of the dataset version if the featurelist is associated with a specific dataset version, for example Informative Features, or null otherwise.
    features:[str]
         Features in the featurelist.
    id:str
         The ID of the featurelist
    name:str
         The name of the featurelist
    user_created:bool
         True if the featurelist was created by a user vs the system.
    """
    _converter = t.Dict(
        {
            t.Key("created_by"):  t.String(),
            t.Key("creation_date"):  t.DateTime(),
            t.Key("dataset_id"):  t.String(),
            t.Key("dataset_version_id"):  t.String(),
            t.Key("features"):  t.List(t.Dict().allow_extra("*")),
            t.Key("id"):  t.String(),
            t.Key("name"):  t.String(),
            t.Key("user_created"):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        created_by,
        creation_date,
        dataset_id,
        dataset_version_id,
        features,
        id,
        name,
        user_created,
    ):
        self.created_by = created_by
        self.creation_date = creation_date
        self.dataset_id = dataset_id
        self.dataset_version_id = dataset_version_id
        self.features = features
        self.id = id
        self.name = name
        self.user_created = user_created

    def __repr__(self):
        return (
            "DatasetFeaturelistResponse("
            "created_by={0.created_by}, "
            "creation_date={0.creation_date}, "
            "dataset_id={0.dataset_id}, "
            "dataset_version_id={0.dataset_version_id}, "
            "features={0.features}, "
            "id={0.id}, "
            "name={0.name}, "
            "user_created={0.user_created}, "
        ).format(self)
